/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.actions;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.skincommons.SkinEditionHelper;
import org.ametys.plugins.skincommons.SkinLockManager;
import org.ametys.skinfactory.SkinFactoryComponent;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.skin.SkinModelsManager;
import org.ametys.web.skin.SkinsManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Request;

public abstract class AbstractSkinAction
extends ServiceableAction {
    public static final String SKIN_FACTORY_TOOL_ID = "uitool-skinfactory";
    protected Context _cocoonContext;
    protected CurrentUserProvider _userProvider;
    protected SiteManager _siteManager;
    protected SkinFactoryComponent _skinFactoryManager;
    protected SkinModelsManager _modelsManager;
    protected SkinLockManager _lockManager;
    protected SkinEditionHelper _skinHelper;
    protected SkinsManager _skinsManager;
    protected UserManager _userManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._skinFactoryManager = (SkinFactoryComponent)((Object)smanager.lookup(SkinFactoryComponent.ROLE));
        this._modelsManager = (SkinModelsManager)smanager.lookup(SkinModelsManager.ROLE);
        this._lockManager = (SkinLockManager)smanager.lookup(SkinLockManager.ROLE);
        this._skinHelper = (SkinEditionHelper)smanager.lookup(SkinEditionHelper.ROLE);
        this._skinsManager = (SkinsManager)smanager.lookup(SkinsManager.ROLE);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
    }

    protected boolean checkLock(Request request, Path skinDir) throws IOException {
        if (!this._lockManager.canWrite(skinDir)) {
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            UserIdentity lockOwner = this._lockManager.getLockOwner(skinDir);
            User user = this._userManager.getUser(lockOwner.getPopulationId(), lockOwner.getLogin());
            result.put("isLocked", true);
            result.put("lockOwner", (Boolean)((Object)(user != null ? user.getFullName() + " (" + String.valueOf(lockOwner) + ")" : lockOwner)));
            request.setAttribute(JSonReader.OBJECT_TO_READ, result);
            return false;
        }
        return true;
    }

    protected boolean checkModelExists(Request request, String modelName) {
        boolean modelExists;
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean bl = modelExists = this._modelsManager.getModel(modelName) != null;
        if (!modelExists) {
            result.put("unknownModel", true);
            result.put("modelName", modelName);
            request.setAttribute(JSonReader.OBJECT_TO_READ, result);
            return false;
        }
        return true;
    }
}

