/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.clientsidelement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.SimpleMenu;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.util.I18nUtils;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.skin.SkinModel;
import org.ametys.web.skin.SkinModelsManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;

public class ModelsMenu
extends SimpleMenu {
    private SkinModelsManager _modelsManager;
    private boolean _modelsInitialized;
    private I18nUtils _i18nUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._modelsManager = (SkinModelsManager)smanager.lookup(SkinModelsManager.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        Map rights = this.getRights(contextParameters);
        if (!ignoreRights && !this.hasRight(rights)) {
            return Collections.EMPTY_LIST;
        }
        try {
            Set models = this._modelsManager.getModels();
            if (models.size() > 0) {
                return super.getScripts(ignoreRights, contextParameters);
            }
            return Collections.EMPTY_LIST;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to lookup client side element local components", e);
        }
    }

    protected void _getGalleryItems(Map<String, Object> parameters, Map<String, Object> contextualParameters) {
        try {
            this._lazyInitializeModelsGallery();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to lookup client side element local components", e);
        }
        if (this._galleryItems.size() > 0) {
            parameters.put("gallery-item", new LinkedHashMap());
            for (SimpleMenu.GalleryItem galleryItem : this._galleryItems) {
                Map galleryItems = (Map)parameters.get("gallery-item");
                galleryItems.put("gallery-groups", new ArrayList());
                for (SimpleMenu.GalleryGroup galleryGp : galleryItem.getGroups()) {
                    List galleryGroups = (List)galleryItems.get("gallery-groups");
                    LinkedHashMap<String, Object> groupParams = new LinkedHashMap<String, Object>();
                    I18nizableText label = galleryGp.getLabel();
                    groupParams.put("label", label);
                    ArrayList<String> gpItems = new ArrayList<String>();
                    for (ClientSideElement element : galleryGp.getItems()) {
                        gpItems.add(element.getId());
                    }
                    if (gpItems.size() <= 0) continue;
                    groupParams.put("items", gpItems);
                    galleryGroups.add(groupParams);
                }
            }
        }
    }

    private synchronized void _lazyInitializeModelsGallery() throws ConfigurationException, ProcessingException {
        if (!this._modelsInitialized) {
            Set models = this._modelsManager.getModels();
            if (models.size() > 0) {
                SimpleMenu.GalleryItem galleryItem = new SimpleMenu.GalleryItem((SimpleMenu)this);
                SimpleMenu.GalleryGroup galleryGroup = new SimpleMenu.GalleryGroup((SimpleMenu)this, new I18nizableText("plugin." + this._pluginName, "PLUGINS_SKINFACTORY_MODELSMENU_GROUP_LABEL"));
                galleryItem.addGroup(galleryGroup);
                for (String id : models) {
                    SkinModel model = this._modelsManager.getModel(id);
                    String itemId = this.getId() + "-" + id;
                    Configuration conf = this._getModelConfiguration(itemId, model);
                    this._getGalleryItemManager().addComponent(this._pluginName, null, itemId, StaticClientSideElement.class, conf);
                    galleryGroup.addItem(new SimpleMenu.UnresolvedItem((SimpleMenu)this, itemId, true));
                }
                this._galleryItems.add(galleryItem);
            }
            if (this._galleryItems.size() > 0) {
                try {
                    this._getGalleryItemManager().initialize();
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unable to lookup parameter local components", (Throwable)e);
                }
            }
        }
        this._modelsInitialized = true;
    }

    protected Configuration _getModelConfiguration(String id, SkinModel model) {
        DefaultConfiguration conf = new DefaultConfiguration("extension");
        conf.setAttribute("id", id);
        DefaultConfiguration classConf = new DefaultConfiguration("class");
        classConf.setAttribute("name", "Ametys.ribbon.element.ui.ButtonController");
        DefaultConfiguration enableToggleConf = new DefaultConfiguration("toggle-enabled");
        enableToggleConf.setValue("true");
        classConf.addChild((Configuration)enableToggleConf);
        DefaultConfiguration labelConf = new DefaultConfiguration("label");
        labelConf.setValue(this._i18nUtils.translate((I18nizable)model.getLabel()));
        classConf.addChild((Configuration)labelConf);
        DefaultConfiguration descriptionConf = new DefaultConfiguration("description");
        descriptionConf.setValue(this._i18nUtils.translate((I18nizable)model.getDescription()));
        classConf.addChild((Configuration)descriptionConf);
        DefaultConfiguration iconSmallConf = new DefaultConfiguration("icon-small");
        iconSmallConf.setValue(model.getSmallImage());
        classConf.addChild((Configuration)iconSmallConf);
        DefaultConfiguration iconMediumConf = new DefaultConfiguration("icon-medium");
        iconMediumConf.setValue(model.getMediumImage());
        classConf.addChild((Configuration)iconMediumConf);
        DefaultConfiguration iconLargeConf = new DefaultConfiguration("icon-large");
        iconLargeConf.setValue(model.getLargeImage());
        classConf.addChild((Configuration)iconLargeConf);
        DefaultConfiguration modelNameConf = new DefaultConfiguration("modelName");
        modelNameConf.setValue(model.getId());
        classConf.addChild((Configuration)modelNameConf);
        Map commonConfig = (Map)this._script.getParameters().get("items-config");
        for (String tagName : commonConfig.keySet()) {
            DefaultConfiguration c = new DefaultConfiguration(tagName);
            c.setValue(String.valueOf(commonConfig.get(tagName)));
            classConf.addChild((Configuration)c);
        }
        conf.addChild((Configuration)classConf);
        return conf;
    }
}

