/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.generators;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.skinfactory.SkinFactoryComponent;
import org.ametys.skinfactory.parameters.AbstractSkinParameter;
import org.ametys.web.skin.SkinModel;
import org.ametys.web.skin.SkinModelsManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GenerateRibbonFile
extends ServiceableGenerator {
    private SkinFactoryComponent _skinFactoryManager;
    private SkinModelsManager _modelsManager;
    private I18nUtils _i18nUtils;
    private final HashMap<Pattern, String> _glyphAssociations = new LinkedHashMap<Pattern, String>();

    public GenerateRibbonFile() {
        this._glyphAssociations.put(Pattern.compile("^(h1|h2|h3|h4)$"), "ametysicon-header");
        this._glyphAssociations.put(Pattern.compile("text"), "ametysicon-text");
        this._glyphAssociations.put(Pattern.compile("link"), "ametysicon-link23");
        this._glyphAssociations.put(Pattern.compile("list"), "ametysicon-list4");
        this._glyphAssociations.put(Pattern.compile("vmenu^$"), "ametysicon-vmenu");
        this._glyphAssociations.put(Pattern.compile("menu"), "ametysicon-menu");
        this._glyphAssociations.put(Pattern.compile("^(item|subitem)$"), "ametysicon-menu-element");
        this._glyphAssociations.put(Pattern.compile("title|header"), "ametysicon-header");
        this._glyphAssociations.put(Pattern.compile("table"), "ametysicon-tables1");
        this._glyphAssociations.put(Pattern.compile("border"), "ametysicon-tables1");
        this._glyphAssociations.put(Pattern.compile("image"), "ametysicon-image2");
        this._glyphAssociations.put(Pattern.compile("."), "ametysicon-designer");
    }

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._skinFactoryManager = (SkinFactoryComponent)((Object)smanager.lookup(SkinFactoryComponent.ROLE));
        this._modelsManager = (SkinModelsManager)smanager.lookup(SkinModelsManager.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"CMS");
        String modelName = this.parameters.getParameter("modelName", null);
        SkinModel model = this._modelsManager.getModel(modelName);
        Path ribbonFile = model.getPath().resolve("model/cms-ribbon.xml");
        if (Files.exists(ribbonFile, new LinkOption[0])) {
            SAXParser saxParser = null;
            try (InputStream is = Files.newInputStream(ribbonFile, new OpenOption[0]);){
                saxParser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
                saxParser.parse(new InputSource(is), (ContentHandler)new IgnoreRootHandler(this.contentHandler));
            }
            catch (ServiceException e) {
                try {
                    throw new ProcessingException("Unable to get a SAX parser", (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.manager.release(saxParser);
                    throw throwable;
                }
            }
            this.manager.release((Object)saxParser);
        }
        Map<String, RibbonTab> tabs = this._getGroupedParams(this._skinFactoryManager.getModelParameters(modelName));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"parameters");
        for (RibbonTab tab : tabs.values()) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", tab.getId());
            attrs.addCDATAAttribute("label", this._i18nUtils.translate((I18nizable)tab.getLabel()));
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"tab", (Attributes)attrs);
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"groups");
            Collection<RibbonGroup> groups = tab.getGroups();
            for (RibbonGroup group : groups) {
                attrs = new AttributesImpl();
                attrs.addCDATAAttribute("id", group.getId());
                attrs.addCDATAAttribute("label", this._i18nUtils.translate((I18nizable)group.getLabel()));
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"group", (Attributes)attrs);
                Collection<RibbonElement> elmts = group.getRibbonElements();
                for (RibbonElement elt : elmts) {
                    if (elt instanceof ParameterControl) {
                        attrs = new AttributesImpl();
                        attrs.addCDATAAttribute("id", elt.getId());
                        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"parameter", (Attributes)attrs);
                        continue;
                    }
                    if (!(elt instanceof Menu)) continue;
                    this._saxMenu((Menu)elt);
                }
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"group");
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"groups");
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"tab");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"parameters");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"CMS");
        this.contentHandler.endDocument();
    }

    private void _saxMenu(Menu menu) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", menu.getId());
        attrs.addCDATAAttribute("label", this._i18nUtils.translate((I18nizable)menu.getLabel()));
        this._saxMenuIcons(menu, attrs);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"menu", (Attributes)attrs);
        for (String itemId : menu.getItems()) {
            attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", itemId);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"parameter", (Attributes)attrs);
        }
        for (Menu submenu : menu.getMenus()) {
            this._saxMenu(submenu);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"menu");
    }

    private Map<String, RibbonTab> _getGroupedParams(Map<String, AbstractSkinParameter> skinParameters) {
        HashMap<String, RibbonTab> tabs = new HashMap<String, RibbonTab>();
        for (AbstractSkinParameter param : skinParameters.values()) {
            String id = param.getId();
            Object[] parts = id.split("\\.");
            String tabId = "org.ametys.skinfactory.Tab." + (parts.length >= 3 ? parts[0] : "default");
            String groupId = parts.length >= 3 ? StringUtils.join((Object[])parts, (String)".", (int)0, (int)2) : "default.default";
            String eltId = null;
            String itemId = null;
            String subItemId = null;
            if (parts.length <= 3 || !param.getType().equals((Object)AbstractSkinParameter.SkinParameterType.CSS)) {
                eltId = StringUtils.join((Object[])parts, (String)".");
            } else {
                eltId = StringUtils.join((Object[])parts, (String)".", (int)0, (int)3);
                String string = itemId = parts.length == 4 ? StringUtils.join((Object[])parts, (String)".") : StringUtils.join((Object[])parts, (String)".", (int)0, (int)4);
                if (parts.length > 4) {
                    subItemId = StringUtils.join((Object[])parts, (String)".");
                }
            }
            this._addGroupedParam(tabs, tabId, groupId, eltId, itemId, subItemId);
        }
        return tabs;
    }

    private void _addGroupedParam(Map<String, RibbonTab> tabs, String tabId, String groupId, String controlId, String itemId, String subItemId) {
        RibbonTab ribbonTab;
        if (!tabs.containsKey(tabId)) {
            tabs.put(tabId, new RibbonTab(this, tabId, new I18nizableText(tabId.substring(tabId.lastIndexOf(".") + 1))));
        }
        if (!(ribbonTab = tabs.get(tabId)).hasGroup(groupId)) {
            ribbonTab.addGroup(new RibbonGroup(this, groupId, new I18nizableText(groupId.substring(groupId.lastIndexOf(".") + 1))));
        }
        RibbonGroup ribbonGroup = ribbonTab.getGroup(groupId);
        if (itemId != null) {
            RibbonElement ribbonControl;
            if (!ribbonGroup.hasRibbonElement(controlId)) {
                ribbonGroup.addRibbonElement(new Menu(this, controlId, new I18nizableText(controlId.substring(controlId.lastIndexOf(".") + 1))));
            }
            if ((ribbonControl = ribbonGroup.getRibbonElement(controlId)) instanceof Menu) {
                Menu menu = (Menu)ribbonControl;
                if (subItemId == null) {
                    menu.addItem(itemId);
                } else {
                    if (!menu.hasMenu(itemId)) {
                        menu.addMenu(new Menu(this, itemId, new I18nizableText(itemId.substring(itemId.lastIndexOf(".") + 1))));
                    }
                    Menu subMenu = menu.getMenu(itemId);
                    subMenu.addItem(subItemId);
                }
            }
        } else {
            ribbonGroup.addRibbonElement(new ParameterControl(this, controlId));
        }
    }

    private void _saxMenuIcons(Menu menu, AttributesImpl attrs) {
        String label = this._i18nUtils.translate((I18nizable)menu.getLabel());
        for (Map.Entry<Pattern, String> entry : this._glyphAssociations.entrySet()) {
            Pattern pattern = entry.getKey();
            if (!pattern.matcher(label).matches()) continue;
            attrs.addCDATAAttribute("iconGlyph", entry.getValue());
            return;
        }
    }

    class RibbonTab {
        private I18nizableText _label;
        private String _id;
        private Map<String, RibbonGroup> _groups;

        public RibbonTab(GenerateRibbonFile this$0, String id, I18nizableText label) {
            this._id = id;
            this._label = label;
            this._groups = new HashMap<String, RibbonGroup>();
        }

        String getId() {
            return this._id;
        }

        I18nizableText getLabel() {
            return this._label;
        }

        Collection<RibbonGroup> getGroups() {
            return this._groups.values();
        }

        void addGroup(RibbonGroup group) {
            this._groups.put(group.getId(), group);
        }

        boolean hasGroup(String groupId) {
            return this._groups.containsKey(groupId);
        }

        RibbonGroup getGroup(String groupId) {
            return this._groups.get(groupId);
        }
    }

    class RibbonGroup {
        private String _id;
        private I18nizableText _label;
        private Map<String, RibbonElement> _ribbonElts;

        public RibbonGroup(GenerateRibbonFile this$0, String id, I18nizableText label) {
            this._id = id;
            this._label = label;
            this._ribbonElts = new HashMap<String, RibbonElement>();
        }

        String getId() {
            return this._id;
        }

        I18nizableText getLabel() {
            return this._label;
        }

        void addRibbonElement(RibbonElement control) {
            this._ribbonElts.put(control.getId(), control);
        }

        boolean hasRibbonElement(String controlId) {
            return this._ribbonElts.containsKey(controlId);
        }

        RibbonElement getRibbonElement(String controlId) {
            return this._ribbonElts.get(controlId);
        }

        Collection<RibbonElement> getRibbonElements() {
            return this._ribbonElts.values();
        }
    }

    static interface RibbonElement {
        public String getId();
    }

    class ParameterControl
    implements RibbonElement {
        private String _id;

        public ParameterControl(GenerateRibbonFile this$0, String id) {
            this._id = id;
        }

        @Override
        public String getId() {
            return this._id;
        }
    }

    class Menu
    implements RibbonElement {
        private String _id;
        private I18nizableText _label;
        private List<String> _items;
        private Map<String, Menu> _menus;

        public Menu(GenerateRibbonFile this$0, String id, I18nizableText label) {
            this._id = id;
            this._label = label;
            this._items = new ArrayList<String>();
            this._menus = new HashMap<String, Menu>();
        }

        @Override
        public String getId() {
            return this._id;
        }

        I18nizableText getLabel() {
            return this._label;
        }

        void addItem(String id) {
            this._items.add(id);
        }

        void addMenu(Menu menu) {
            this._menus.put(menu.getId(), menu);
        }

        boolean hasMenu(String menuId) {
            return this._menus.containsKey(menuId);
        }

        Menu getMenu(String menuId) {
            return this._menus.get(menuId);
        }

        List<String> getItems() {
            return this._items;
        }

        Collection<Menu> getMenus() {
            return this._menus.values();
        }
    }
}

