<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
	<xsl:param name="skinName"/>
		
	<xsl:template match="/cms">
		<script type="text/javascript">
			(function () {
			
				var control;
				<xsl:apply-templates select="ribbon/tab/groups/group/medium/*"/>
				
				var ribbonItems = [];		
				<xsl:apply-templates select="ribbon/tab"/>
				var ribbon = Ext.getCmp("ribbon");
				ribbon.getPanel().add(ribbonItems);
				
				var tab = Ext.create("Ametys.ribbon.element.tab.TabController", {
					"tool-id":"^(uitool-skinfactory)$",
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				});
				Ametys.ribbon.RibbonManager.registerTab(tab);
		
				<xsl:apply-templates select="ribbon/tab" mode="contextual-tabs">
					<xsl:sort order="descending" select="position()" data-type="number"/>
				</xsl:apply-templates>
				
			}) ();
		</script>
	</xsl:template>
	
	<!-- +
		 | Create ribbon tabs 
		 + -->
	<xsl:template match="tab">
		<xsl:variable name="tabPos">SF_<xsl:value-of select="position()"/></xsl:variable>
		
		<!-- Ribbon tabs -->
		var tab_<xsl:value-of select="$tabPos"/> =  Ext.create("Ametys.ui.fluent.ribbon.Panel", {<xsl:text/>
				<xsl:text/>title: '<xsl:value-of select="@label"/>',<xsl:text/>
				<xsl:text/>controlId: 'SF_<xsl:value-of select="position()"/>',<xsl:text/>
				<xsl:if test="@contextualColor"><xsl:text/>contextualTab: '<xsl:value-of select="@contextualColor"/>',<xsl:text/></xsl:if>
				<xsl:if test="@contextualGroup"><xsl:text/>contextualGroup: '<xsl:value-of select="@contextualGroup"/>',<xsl:text/></xsl:if>
				<xsl:if test="@contextualLabel"><xsl:text/>contextualLabel: '<xsl:value-of select="@contextualLabel"/>',<xsl:text/></xsl:if>
				<xsl:text/>items: []<xsl:text/>
			<xsl:text>});</xsl:text>
			
		<xsl:apply-templates select="groups/group">
			<xsl:with-param name="tabPos" select="$tabPos"/>
		</xsl:apply-templates>
        
        ribbonItems.push(tab_<xsl:value-of select="$tabPos"/>);<xsl:text/>
	</xsl:template>
	
	<xsl:template match="tab" mode="contextual-tabs">
		<xsl:variable name="tabPos">SF_<xsl:value-of select="count(preceding-sibling::*) + 1"/></xsl:variable>
        
        tab.attachTab(tab_<xsl:value-of select="$tabPos"/>);
	</xsl:template>
	
	<!-- +
		 | Create ribbon groups 
		 + -->
	<xsl:template match="group">
		<xsl:param name="tabPos"/>
		
		<xsl:variable name="groupPos"><xsl:value-of select="position()"/></xsl:variable>

        var fgp_<xsl:value-of select="$tabPos"/>_<xsl:value-of select="$groupPos"/>_small = [];<xsl:text/>
        var fgp_<xsl:value-of select="$tabPos"/>_<xsl:value-of select="$groupPos"/>_medium = [];<xsl:text/>
        var fgp_<xsl:value-of select="$tabPos"/>_<xsl:value-of select="$groupPos"/>_large = [];<xsl:text/>
        
       <xsl:for-each select="medium/*|small/*|large/*">
			<xsl:variable name="id" select="@id"/>
			
			<xsl:choose>
				<xsl:when test="local-name()='parameter' and @id = /cms/parameters/parameter/@id">
           			fgp_<xsl:value-of select="$tabPos"/>_<xsl:value-of select="$groupPos"/>_<xsl:value-of select="local-name(..)"/>.push(<xsl:text/>
			        	<xsl:text/>Ametys.ribbon.RibbonManager.getUI("<xsl:value-of select="$id"/>").addUI("large")<xsl:text/> 
					<xsl:text/>);<xsl:text/>
           		</xsl:when>
           		<xsl:when test="local-name()='menu'">
           			fgp_<xsl:value-of select="$tabPos"/>_<xsl:value-of select="$groupPos"/>_<xsl:value-of select="local-name(..)"/>.push(<xsl:text/>
			        	<xsl:text/>Ametys.ribbon.RibbonManager.getUI("<xsl:value-of select="$id"/>").addUI("large")<xsl:text/> 
					<xsl:text/>);<xsl:text/>
           		</xsl:when>
           		<xsl:when test="local-name()='layout'">
           			<xsl:variable name="layoutPos"><xsl:value-of select="position()"/></xsl:variable>
					
					fgp_<xsl:value-of select="$tabPos"/>_<xsl:value-of select="$groupPos"/>_<xsl:value-of select="local-name(..)"/>.push({<xsl:text/>
                        	columns: <xsl:choose><xsl:when test="@cols"><xsl:value-of select="@cols"/></xsl:when><xsl:otherwise>1</xsl:otherwise></xsl:choose>,
                        	align: '<xsl:value-of select="@align"/>',
                        	items: [
                        		<xsl:for-each select="menu | parameter[@id = /cms/parameters/parameter/@id] | toolbar"><xsl:if test="position() != 1">, </xsl:if>
                        			<xsl:choose>
										<xsl:when test="local-name() = 'menu' or (local-name() = 'parameter' and @id = /cms/parameters/parameter/@id)">
											<xsl:variable name="id" select="@id"/>
											<xsl:variable name="colspan">
												<xsl:choose>
													<xsl:when test="@colspan"><xsl:value-of select="@colspan"/></xsl:when>
													<xsl:otherwise>1</xsl:otherwise>
												</xsl:choose>
											</xsl:variable>
            								Ametys.ribbon.RibbonManager.getUI("<xsl:value-of select="$id"/>").addUI("<xsl:value-of select="../@size"/>", <xsl:value-of select="$colspan"/>)<xsl:text/>
            							</xsl:when>
										<xsl:when test="local-name()='toolbar'"> 
            								{ colspan: '<xsl:value-of select="@colspan"/>', items: [<xsl:text/>
                          						<xsl:for-each select="parameter[@id = /cms/parameters/parameter/@id]"><xsl:if test="position() != 1">, </xsl:if>
													<xsl:variable name="id" select="@id"/>
													<xsl:variable name="colspan">
														<xsl:choose>
															<xsl:when test="@colspan"><xsl:value-of select="@colspan"/></xsl:when>
															<xsl:otherwise>1</xsl:otherwise>
														</xsl:choose>
													</xsl:variable>
            										Ametys.ribbon.RibbonManager.getUI("<xsl:value-of select="$id"/>").addUI("very-small", <xsl:value-of select="$colspan"/>)<xsl:text/>
                          						</xsl:for-each>
               								<xsl:text/>]}<xsl:text/>
										</xsl:when>
            				 		</xsl:choose>
                        		</xsl:for-each>
                        	]
                        }
              	  <xsl:text/>);<xsl:text/>
           		</xsl:when>
            </xsl:choose>
		</xsl:for-each>   
		
		var fgp_<xsl:value-of select="$tabPos"/>_<xsl:value-of select="$groupPos"/> = {
				title: '<xsl:value-of select="@label"/>',
				priority: 0,
				smallItems: fgp_<xsl:value-of select="$tabPos"/>_<xsl:value-of select="$groupPos"/>_small,
				items: fgp_<xsl:value-of select="$tabPos"/>_<xsl:value-of select="$groupPos"/>_medium,
				largeItems: fgp_<xsl:value-of select="$tabPos"/>_<xsl:value-of select="$groupPos"/>_large
		};      
		
		tab_<xsl:value-of select="$tabPos"/>.add(fgp_<xsl:value-of select="$tabPos"/>_<xsl:value-of select="$groupPos"/>);    	
	</xsl:template>
	
	<!-- +
		 | Create ribbon controls 
		 + -->
	<xsl:template match="parameter">
		<xsl:variable name="id" select="@id"/>
		<xsl:choose>
			<xsl:when test="/cms/parameters/parameter[@id = $id]/@type = 'variant'">
				<xsl:apply-templates select="/cms/parameters/parameter[@id = $id]" mode="variant"/>
			</xsl:when>
			<xsl:when test="/cms/parameters/parameter[@id = $id]/@type = 'css'">
				<xsl:apply-templates select="/cms/parameters/parameter[@id = $id]" mode="css"/>
			</xsl:when>
			<xsl:when test="/cms/parameters/parameter[@id = $id]/@type = 'image'">
				<xsl:apply-templates select="/cms/parameters/parameter[@id = $id]" mode="image"/>
			</xsl:when>
			<xsl:when test="/cms/parameters/parameter[@id = $id]/@type = 'i18n'">
				<xsl:apply-templates select="/cms/parameters/parameter[@id = $id]" mode="i18n"/>
			</xsl:when>
			<xsl:when test="/cms/parameters/parameter[@id = $id]/@type = 'text'">
				<xsl:apply-templates select="/cms/parameters/parameter[@id = $id]" mode="text"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="menu">
		control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
			menuClass: "Ametys.plugins.skinfactory.widgets.menu.ParametersMenu",
			label: "<xsl:value-of select="@label"/>",
			description: "<xsl:value-of select="@description"/>",
			"icon-glyph": "<xsl:value-of select="@icon-glyph"/>",
			"icon-small": "<xsl:value-of select="@icon-small"/>",
			"icon-medium": "<xsl:value-of select="@icon-medium"/>",
			"icon-large": "<xsl:value-of select="@icon-medium"/>",
			parameters: {<xsl:apply-templates select="parameter|menu" mode="menu"/>}
			},
			{
				 id: "<xsl:value-of select="@id"/>",
				  pluginName: "skinfactory"
		 }));
		Ametys.ribbon.RibbonManager.registerUI(control);
	</xsl:template>
	
	<xsl:template match="parameter" mode="menu">
		<xsl:choose>
			<xsl:when test="/cms/parameters/parameter[@id = current()/@id]/@type = 'image'">
				'<xsl:value-of select="@id"/>': { 
					'type': 'image-gallery',
					'libraryPath': "<xsl:value-of select="escaper:escapeJavaScript(/cms/parameters/parameter[@id = current()/@id]/path)"/>",
					'label': "<xsl:value-of select="/cms/parameters/parameter[@id = current()/@id]/label"/>",
					'description':  "<xsl:value-of select="/cms/parameters/parameter[@id = current()/@id]/description"/>"
				}<xsl:if test="position() != last()">,</xsl:if>
			</xsl:when>
			<xsl:when test="/cms/parameters/parameter[@id = current()/@id]/@type = 'variant'">
				'<xsl:value-of select="@id"/>': { 
					'type': 'variant-gallery',
					'label': "<xsl:value-of select="/cms/parameters/parameter[@id = current()/@id]/label"/>",
					'description':  "<xsl:value-of select="/cms/parameters/parameter[@id = current()/@id]/description"/>"
				}<xsl:if test="position() != last()">,</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				'<xsl:value-of select="@id"/>': { 
					'type': 'item',
					'cssProperty': '<xsl:value-of select="/cms/parameters/parameter[@id = current()/@id]/property"/>',
					'label': "<xsl:value-of select="/cms/parameters/parameter[@id = current()/@id]/label"/>",
					'description':  "<xsl:value-of select="/cms/parameters/parameter[@id = current()/@id]/description"/>"
				}<xsl:if test="position() != last()">,</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="menu" mode="menu">
			'<xsl:value-of select="@id"/>': {
				'type': 'menu',
				'label': "<xsl:value-of select="@label"/>",
				'description':  "<xsl:value-of select="@description"/>",
				"iconCls": "<xsl:value-of select="@icon-glyph"/>",
				'icon': "<xsl:value-of select="@icon-small"/>",
				'parameters': {<xsl:apply-templates select="parameter|menu" mode="menu"/>
				}
			}<xsl:if test="position() != last()">,</xsl:if>
	</xsl:template>
	
	<!-- +
		 | Create ribbon control for css parameters
		 + -->
	<xsl:template match="parameter" mode="css">
		<xsl:choose>
			<xsl:when test="property = 'font-family'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "font-family",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-glyph": "ametysicon-font-family",
					"icon-medium": "/plugins/skinfactory/resources/img/button/police_32.png", 
					"icon-small": "/plugins/skinfactory/resources/img/button/police_16.png", 
					"icon-large": "/plugins/skinfactory/resources/img/button/police_32.png" 
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'font-size'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "font-size",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-glyph": "ametysicon-font-size",
					"icon-medium": "/plugins/skinfactory/resources/img/button/fontsize_32.png", 
					"icon-small": "/plugins/skinfactory/resources/img/button/fontsize_16.png", 
					"icon-large": "/plugins/skinfactory/resources/img/button/fontsize_32.png" 
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'height' or property = 'min-height'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "height",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-medium": "/plugins/skinfactory/resources/img/button/height_32.png", 
					"icon-small": "/plugins/skinfactory/resources/img/button/height_16.png", 
					"icon-large": "/plugins/skinfactory/resources/img/button/height_32.png" 
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
            <xsl:when test="property = 'top'">
                control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "top",
                    paramId: "<xsl:value-of select="@id"/>",
                    label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
                    "icon-medium": "/plugins/skinfactory/resources/img/button/height_32.png", 
                    "icon-small": "/plugins/skinfactory/resources/img/button/height_16.png", 
                    "icon-large": "/plugins/skinfactory/resources/img/button/height_32.png" ,
                }, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
            </xsl:when>
            <xsl:when test="property = 'bottom'">
                control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "bottom",
                    paramId: "<xsl:value-of select="@id"/>",
                    label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
                    "icon-medium": "/plugins/skinfactory/resources/img/button/height_32.png", 
                    "icon-small": "/plugins/skinfactory/resources/img/button/height_16.png", 
                    "icon-large": "/plugins/skinfactory/resources/img/button/height_32.png" ,
                }, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
            </xsl:when>
			<xsl:when test="property = 'width' or property = 'min-width'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "width",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-medium": "/plugins/skinfactory/resources/img/button/width_32.png", 
					"icon-small": "/plugins/skinfactory/resources/img/button/width_16.png", 
					"icon-large": "/plugins/skinfactory/resources/img/button/width_32.png" 
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
            <xsl:when test="property = 'left'">
                control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "left",
                    paramId: "<xsl:value-of select="@id"/>",
                    label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
                    "icon-medium": "/plugins/skinfactory/resources/img/button/width_32.png", 
                    "icon-small": "/plugins/skinfactory/resources/img/button/width_16.png", 
                    "icon-large": "/plugins/skinfactory/resources/img/button/width_32.png" ,
                }, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
            </xsl:when>
            <xsl:when test="property = 'right'">
                control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "right",
                    paramId: "<xsl:value-of select="@id"/>",
                    label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
                    "icon-medium": "/plugins/skinfactory/resources/img/button/width_32.png", 
                    "icon-small": "/plugins/skinfactory/resources/img/button/width_16.png", 
                    "icon-large": "/plugins/skinfactory/resources/img/button/width_32.png" ,
                }, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
            </xsl:when>
			<xsl:when test="property = 'font-style'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.item.FontStyleItalicItem",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					"description":  "<xsl:value-of select="description"/>"
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'font-weight'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.item.FontStyleBoldItem",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					"description":  "<xsl:value-of select="description"/>"
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'text-decoration'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.item.FontStyleUnderlineItem",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					"description":  "<xsl:value-of select="description"/>"
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'color'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.ColorSelectorMenu",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-glyph": "ametysicon-color-text",
					"icon-medium": "/plugins/skinfactory/resources/img/button/fontcolor_32.png", 
					"icon-small": "/plugins/skinfactory/resources/img/button/fontcolor_16.png", 
					"icon-large": "/plugins/skinfactory/resources/img/button/fontcolor_32.png" 
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'border-color' or property = 'border-top-color' or property = 'border-bottom-color' or property = 'border-left-color' or property = 'border-right-color'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.ColorSelectorMenu",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-glyph": "ametysicon-painter-border",
					"icon-medium": "/plugins/skinfactory/resources/img/button/border_color_32.png", 
					"icon-small": "/plugins/skinfactory/resources/img/button/border_color_16.png", 
					"icon-large": "/plugins/skinfactory/resources/img/button/border_color_32.png" 
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'background-color'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.ColorSelectorMenu",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-glyph": "ametysicon-paint-bucket",
					"icon-medium": "/plugins/skinfactory/resources/img/button/bgcolor_32.png", 
					"icon-small": "/plugins/skinfactory/resources/img/button/bgcolor_16.png", 
					"icon-large": "/plugins/skinfactory/resources/img/button/bgcolor_32.png" 
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'line-height'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "line-height",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-medium": "/plugins/skinfactory/resources/img/button/line_height_32.png", 
					"icon-small": "/plugins/skinfactory/resources/img/button/line_height_16.png", 
					"icon-large": "/plugins/skinfactory/resources/img/button/line_height_32.png" 
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'letter-spacing'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "letter-spacing",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-medium": "/plugins/skinfactory/resources/img/button/letter_spacing_32.png", 
					"icon-small": "/plugins/skinfactory/resources/img/button/letter_spacing_16.png", 
					"icon-large": "/plugins/skinfactory/resources/img/button/letter_spacing_32.png" 
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'text-indent'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "text-indent",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-medium": "/plugins/skinfactory/resources/img/button/text_indent_16.gif", 
					"icon-small": "/plugins/skinfactory/resources/img/button/text_indent_32.png", 
					"icon-large": "/plugins/skinfactory/resources/img/button/text_indent_32.png" 
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'text-align'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.TextAlignMenu",
					cssStyle: 'text-align',
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-medium": "/plugins/skinfactory/resources/img/button/alignleft_32.png", 
					"icon-small": "/plugins/skinfactory/resources/img/button/alignleft_16.png", 
					"icon-large": "/plugins/skinfactory/resources/img/button/alignleft_32.png" 
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'margin' or property = 'padding'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "margin",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-glyph": "ametysicon-margin",
					"icon-medium": "/plugins/skinfactory/resources/img/button/margin_32.png", 
					"icon-small": "/plugins/skinfactory/resources/img/button/margin_16.png", 
					"icon-large": "/plugins/skinfactory/resources/img/button/margin_32.png" 
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'margin-left' or property = 'padding-left'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "margin",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-medium": "/plugins/skinfactory/resources/img/button/margin_left_32.png", 
					"icon-small": "/plugins/skinfactory/resources/img/button/margin_left_16.png", 
					"icon-large": "/plugins/skinfactory/resources/img/button/margin_left_32.png" 
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'margin-right' or property = 'padding-right'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.item.CssStyleWidgetMenu",
					cssStyle: "margin",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-medium": "/plugins/skinfactory/resources/img/button/margin_right_32.png", 
					"icon-small": "/plugins/skinfactory/resources/img/button/margin_right_16.png", 
					"icon-large": "/plugins/skinfactory/resources/img/button/margin_right_32.png" 
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'border-width' or property = 'border-top-width' or property = 'border-bottom-width' or property = 'border-left-width' or property = 'border-right-width'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "border-width",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-glyph": "ametysicon-border-width"
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'border-radius' or property = 'border-top-left-radius' or property = 'border-top-right-radius' or property = 'border-bottom-left-radius' or property = 'border-bottom-right-radius'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "border-radius",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-glyph": "ametysicon-rounded-corners"
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'background-position'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "background-position",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-glyph": "ametysicon-background"
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'background-repeat'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "background-repeat",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-glyph": "ametysicon-background"
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
			<xsl:when test="property = 'border-style' or property = 'border-top-style' or property = 'border-bottom-style' or property = 'border-left-style' or property = 'border-right-style'">
				control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
					menuClass: "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu",
					cssStyle: "border-style",
					paramId: "<xsl:value-of select="@id"/>",
					label: "<xsl:value-of select="label"/>",
					description:  "<xsl:value-of select="description"/>",
					"icon-glyph": "ametysicon-border-style"
				}, {
					id: "<xsl:value-of select="@id"/>",
					pluginName: "skinfactory"
				}));
				Ametys.ribbon.RibbonManager.registerUI(control);
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<!-- +
		 | Create ribbon control for variant
		 + -->
	<xsl:template match="parameter" mode="variant">
		control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
			menuClass: "Ametys.plugins.skinfactory.widgets.gallery.VariantsGallery",
			"icon-glyph": "<xsl:value-of select="iconGlyph"/>", 
			"icon-medium": "<xsl:value-of select="iconLarge"/>", 
			"icon-small": "<xsl:value-of select="iconSmall"/>", 
			"icon-large": "<xsl:value-of select="iconLarge"/>", 
			description:  "<xsl:value-of select="description"/>",
			label: "<xsl:value-of select="label"/>",
			paramId: "<xsl:value-of select="@id"/>"
		}, {
			id: "<xsl:value-of select="@id"/>",
			pluginName: "skinfactory"
		}));
		Ametys.ribbon.RibbonManager.registerUI(control);
	</xsl:template>
	
	<!-- +
		 | Create ribbon control for image parameter
		 + -->
	<xsl:template match="parameter" mode="image">
		control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.WidgetButtonController", Ext.apply({
			menuClass: "Ametys.plugins.skinfactory.widgets.gallery.ImagesGallery",
			"icon-glyph": "<xsl:value-of select="iconGlyph"/>", 
			"icon-medium": "<xsl:value-of select="iconLarge"/>", 
			"icon-small": "<xsl:value-of select="iconSmall"/>", 
			"icon-large": "<xsl:value-of select="iconLarge"/>",
			description:  "<xsl:value-of select="description"/>",
			label: "<xsl:value-of select="label"/>",
			paramId: "<xsl:value-of select="escaper:escapeJavaScript(@id)"/>",
			"enableLocalUpload": "true",
			"libraryPath": "<xsl:value-of select="escaper:escapeJavaScript(path)"/>"
		}, {
			id: "<xsl:value-of select="@id"/>",
			pluginName: "skinfactory"
		}));
		Ametys.ribbon.RibbonManager.registerUI(control);
	</xsl:template>
	
	<!-- +
		 | Create ribbon control for i18n parameter
		 + -->
	<xsl:template match="parameter" mode="i18n">
		control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.I18nInputText", {
			description:  "<xsl:value-of select="description"/>",
			label: "<xsl:value-of select="label"/>",
			paramId: "<xsl:value-of select="@id"/>",
			width: 400,
			id: "<xsl:value-of select="@id"/>",
			pluginName: "skinfactory"
		});
		Ametys.ribbon.RibbonManager.registerUI(control);
	</xsl:template>
	
	<!-- +
		 | Create ribbon control for text parameter
		 + -->
	<xsl:template match="parameter" mode="text">
		control = Ext.create("Ametys.plugins.skinfactory.widgets.controller.InputText", Ext.apply({
			description:  "<xsl:value-of select="description"/>",
			label: "<xsl:value-of select="label"/>",
			paramId: "<xsl:value-of select="@id"/>"
		}, {
			id: "<xsl:value-of select="@id"/>",
			pluginName: "skinfactory"
		}));
        Ametys.ribbon.RibbonManager.registerUI(control);
	</xsl:template>
</xsl:stylesheet>