<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:stringutils="org.apache.commons.lang.StringUtils"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

    <xsl:template name="gdpr-sharethis" >
        <xsl:param name="publisher" />
        <xsl:param name="lang" />
        <xsl:param name="fbLang" />
        
        <xsl:variable name="params">
            publisher:'<xsl:value-of select="$publisher" />'
            <xsl:if test="$lang != ''">, lang:'<xsl:value-of select="$lang"/>'</xsl:if>
            <xsl:if test="$fbLang != ''">, fbLang:'<xsl:value-of select="$fbLang"/>'</xsl:if>
        </xsl:variable>
        
        <script type="text/javascript">
            var switchTo5x=true; // Multi Post
            $j(document).ready(function() 
            {
                var baseUrl = document.location.protocol == 'https:' ? 'https://ws.' : 'http://w.';
                $j.getScript(baseUrl + "sharethis.com/button/buttons.js", function(data, textStatus) {stLight.options({<xsl:value-of select="$params"/>}); });
            });
        </script>
        
    </xsl:template>
    
</xsl:stylesheet>
