/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.socialnetworking;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.ametys.core.captcha.CaptchaHelper;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.cache.PageHelper;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class SendMailAction
extends ServiceableAction {
    protected static final Pattern EMAIL_VALIDATOR = Pattern.compile("^([a-z0-9._-]+@[a-z0-9.-]{2,}[.][a-zA-Z0-9]{2,})?$");
    protected static final Pattern EMAIL_LIST_VALIDATOR = Pattern.compile("^([a-z0-9._-]+@[a-z0-9.-]{2,}[.][a-z]{2,})?(\\s*,\\s*([a-z0-9._-]+@[a-z0-9.-]{2,}[.][a-z]{2,})?)*$");
    protected static final Pattern TEXT_VALIDATOR = Pattern.compile("^\\s*$");
    protected AmetysObjectResolver _resolver;
    protected I18nUtils _i18nUtils;
    protected PageHelper _pageHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
        this._pageHelper = (PageHelper)smanager.lookup(PageHelper.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        String emailBy;
        String captchaValue;
        String captchaKey;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String pageId = this._getPageId(request);
        Page page = (Page)this._resolver.resolveById(pageId);
        if (this._pageHelper.isCaptchaRequired((SitemapElement)page) && !CaptchaHelper.checkAndInvalidate((String)(captchaKey = request.getParameter("captcha-key")), (String)(captchaValue = request.getParameter("captcha-value")))) {
            errors.add(new I18nizableText("plugin.socialnetworking", "PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_ERROR_CAPTCHA"));
        }
        if ((emailBy = request.getParameter("email")) == null || !EMAIL_VALIDATOR.matcher(StringUtils.trimToEmpty((String)emailBy)).matches() || TEXT_VALIDATOR.matcher(StringUtils.trimToEmpty((String)emailBy)).matches()) {
            errors.add(new I18nizableText("plugin.socialnetworking", "PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_ERROR_MAILBY"));
        } else {
            result.put("emailBy", emailBy);
        }
        String emailTo = request.getParameter("emailTo");
        if (emailTo == null || !EMAIL_LIST_VALIDATOR.matcher(StringUtils.trimToEmpty((String)emailTo)).matches() || TEXT_VALIDATOR.matcher(StringUtils.trimToEmpty((String)emailTo)).matches()) {
            errors.add(new I18nizableText("plugin.socialnetworking", "PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_ERROR_MAILTO"));
        } else {
            result.put("emailTo", emailTo);
        }
        String userName = request.getParameter("name");
        if (userName == null || TEXT_VALIDATOR.matcher(StringUtils.trimToEmpty((String)userName)).matches()) {
            errors.add(new I18nizableText("plugin.socialnetworking", "PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_ERROR_NAME"));
        } else {
            result.put("name", userName);
        }
        String text = request.getParameter("text");
        if (text == null) {
            errors.add(new I18nizableText("plugin.socialnetworking", "PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_ERROR_CONTENT"));
        } else {
            result.put("text", text);
        }
        if (errors.isEmpty()) {
            String pagePath = request.getHeader("Referer");
            String lang = page.getSitemapName();
            ArrayList<String> i18nparam = new ArrayList<String>();
            i18nparam.add(page.getTitle());
            i18nparam.add(page.getSite().getTitle());
            I18nizableText i18nTextSubject = new I18nizableText("plugin.socialnetworking", "PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_SUBJECT", i18nparam);
            String subject = this._i18nUtils.translate((I18nizable)i18nTextSubject, lang);
            i18nparam = new ArrayList();
            i18nparam.add(userName);
            i18nparam.add(pagePath);
            i18nparam.add(text);
            i18nparam.add(page.getSite().getUrl());
            I18nizableText i18nTextBody = new I18nizableText("plugin.socialnetworking", "PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_TEXT_BODY", i18nparam);
            String textBody = this._i18nUtils.translate((I18nizable)i18nTextBody, lang);
            StandardMailBodyHelper.MailBodyBuilder bodyBuilder = StandardMailBodyHelper.newHTMLBody().withMessage(new I18nizableText("plugin.socialnetworking", "PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_HTML_BODY", i18nparam)).withLanguage(lang).withTitle(subject).withLink(page.getSite().getUrl(), new I18nizableText("plugin.socialnetworking", "PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_HTML_BODY_SITE_LINK"));
            if (StringUtils.isNotEmpty((CharSequence)text)) {
                bodyBuilder.withDetails(new I18nizableText("plugin.socialnetworking", "PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_HTML_BODY_MESSAGE"), text, false);
            }
            String htmlBody = bodyBuilder.build();
            String[] tabMail = StringUtils.split((String)emailTo, (String)",");
            for (int i = 0; i < tabMail.length; ++i) {
                try {
                    SendMailHelper.newMail().withSubject(subject).withHTMLBody(htmlBody).withTextBody(textBody).withSender(emailBy).withRecipient(StringUtils.trimToEmpty((String)tabMail[i])).sendMail();
                    continue;
                }
                catch (MessagingException | IOException e) {
                    if (!result.containsKey("mailError")) {
                        result.put("mailError", new ArrayList());
                    }
                    ((List)result.get("mailError")).add(tabMail[i]);
                    this.getLogger().error("Failed to send mail to '" + tabMail[i] + "'", e);
                }
            }
        }
        result.put("error", errors);
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        return EMPTY_MAP;
    }

    private String _getPageId(Request request) {
        String pageId = request.getParameter("page-id");
        if (pageId == null) {
            throw new IllegalStateException("Unable to send page by mail: cannot determine the current page");
        }
        Page page = (Page)this._resolver.resolveById(pageId);
        if (page == null) {
            throw new IllegalStateException("Unable to send page by mail: the page of id " + pageId + " is unknown");
        }
        return pageId;
    }
}

