<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2014 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
	
	<xsl:template match="/ActionResult">
		<html>
			<head/>
			
			<body id="default">
				<xsl:choose>
					<xsl:when test="error">
						<div class="submit-errors">
							<h1><i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_ERROR_TITLE" i18n:catalogue="plugin.socialnetworking"/></h1>
							<p><i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_ERROR_DESCRIPTION" i18n:catalogue="plugin.socialnetworking"/></p>
							<ul>
								<xsl:for-each select="error">
									<li><xsl:value-of select="."/></li>
								</xsl:for-each>
							</ul>
							<noscript>
								<p><i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_ERROR_BACK_ALT" i18n:catalogue="plugin.socialnetworking"/></p>
							</noscript>
							<script type="text/javascript">
								document.write("&lt;p&gt;&lt;a href='javascript: history.back();'&gt;<i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_ERROR_BACK" i18n:catalogue="plugin.socialnetworking"/>&lt;/a&gt;&lt;/p&gt;")
							</script>
						</div>
					</xsl:when>
					<xsl:otherwise>
						<div class="submit-success">
							<h1><i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_SUCCESS_TITLE" i18n:catalogue="plugin.socialnetworking"/></h1>
							<p><i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_SUCCESS_DESCRIPTION" i18n:catalogue="plugin.socialnetworking"/></p>
							<p><i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_SUCCESS_DESCRIPTION2" i18n:catalogue="plugin.socialnetworking"/></p>
							<xsl:if test="string-length(redirect) &gt; 0">
								<p><a href="{redirect}"><i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_SUCCESS_BACK" i18n:catalogue="plugin.socialnetworking"/></a></p>
							</xsl:if>
						</div>
					</xsl:otherwise>
				</xsl:choose>
			</body>
		</html>
	</xsl:template>
	
</xsl:stylesheet>