<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
			    xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

    <xsl:import href="gdpr:sharethis"/>

	<xsl:template name="ShareThis">
		<xsl:param name="layout">classic</xsl:param>
        <xsl:param name="lang"/>
        <xsl:param name="feature-mail">true</xsl:param>
        <xsl:param name="feature-facebook">true</xsl:param>
        <xsl:param name="feature-twitter">true</xsl:param>
        <xsl:param name="feature-linkedin">true</xsl:param>
        <xsl:param name="feature-pinterest">true</xsl:param>
        <xsl:param name="feature-sharethis">true</xsl:param>
        
        <xsl:param name="fbLang">
            <xsl:call-template name="fb-lang"><xsl:with-param name="lang" select="$lang"/></xsl:call-template>
        </xsl:param>
		
		<xsl:call-template name="gdpr-sharethis">
		  <xsl:with-param name="publisher">7fcfec1e-16ef-41a0-8902-67b9f511c6ba</xsl:with-param>
		  <xsl:with-param name="lang" select="$lang" />
          <xsl:with-param name="fbLang" select="$fbLang" />
        </xsl:call-template>
        
		<xsl:choose>
			<xsl:when test="$layout = 'classic'">
				<script type="text/javascript">
					document.write("&lt;span class='st_sharethis' displayText='ShareThis'&gt;&lt;/span&gt;");
				</script>
			</xsl:when>
			<xsl:when test="$layout = 'multi-channel'">
				<script type="text/javascript">
					<xsl:if test="$feature-twitter = 'true'">document.write("&lt;span class='st_twitter'&gt;&lt;/span&gt;");</xsl:if>
					<xsl:if test="$feature-facebook = 'true'">document.write("&lt;span class='st_facebook'&gt;&lt;/span&gt;");</xsl:if>
                    <xsl:if test="$feature-linkedin = 'true'">document.write("&lt;span class='st_linkedin'&gt;&lt;/span&gt;");</xsl:if>
                    <xsl:if test="$feature-pinterest = 'true'">document.write("&lt;span class='st_pinterest'&gt;&lt;/span&gt;");</xsl:if>
                    <xsl:if test="$feature-mail = 'true'">document.write("&lt;span class='st_email'&gt;&lt;/span&gt;");</xsl:if>
					<xsl:if test="$feature-sharethis = 'true'">document.write("&lt;span class='st_sharethis'&gt;&lt;/span&gt;");</xsl:if>
				</script>
			</xsl:when>
			<xsl:when test="$layout = 'multi-channel-large'">
				<script type="text/javascript">
					<xsl:if test="$feature-twitter = 'true'">document.write("&lt;span class='st_twitter_large' displayText='Tweet'&gt;&lt;/span&gt;");</xsl:if>
					<xsl:if test="$feature-facebook = 'true'">document.write("&lt;span class='st_facebook_large' displayText='Facebook'&gt;&lt;/span&gt;");</xsl:if>
                    <xsl:if test="$feature-linkedin = 'true'">document.write("&lt;span class='st_linkedin_large' displayText='LinkedIn'&gt;&lt;/span&gt;");</xsl:if>
                    <xsl:if test="$feature-pinterest = 'true'">document.write("&lt;span class='st_pinterest_large' displayText='Pinterest'&gt;&lt;/span&gt;");</xsl:if>
					<xsl:if test="$feature-mail = 'true'">document.write("&lt;span class='st_email_large' displayText='Email'&gt;&lt;/span&gt;");</xsl:if>
					<xsl:if test="$feature-sharethis = 'true'">document.write("&lt;span class='st_sharethis_large' displayText='ShareThis'&gt;&lt;/span&gt;");</xsl:if>
				</script>
			</xsl:when>
			<xsl:when test="$layout = 'vertical-counter'">
				<script type="text/javascript">
					<xsl:if test="$feature-twitter = 'true'">document.write("&lt;span class='st_twitter_vcount' displayText='Tweet'&gt;&lt;/span&gt;");</xsl:if>
					<xsl:if test="$feature-facebook = 'true'">document.write("&lt;span class='st_facebook_vcount' displayText='Share'&gt;&lt;/span&gt;");</xsl:if>
                    <xsl:if test="$feature-linkedin = 'true'">document.write("&lt;span class='st_linkedin_vcount' displayText='LinkedIn'&gt;&lt;/span&gt;");</xsl:if>
                    <xsl:if test="$feature-pinterest = 'true'">document.write("&lt;span class='st_pinterest_vcount' displayText='Pinterest'&gt;&lt;/span&gt;");</xsl:if>
					<xsl:if test="$feature-mail = 'true'">document.write("&lt;span class='st_email_vcount' displayText='Email'&gt;&lt;/span&gt;");</xsl:if>
					<xsl:if test="$feature-sharethis = 'true'">document.write("&lt;span class='st_sharethis_vcount' displayText='Share'&gt;&lt;/span&gt;");</xsl:if>
				</script>
			</xsl:when>
			<xsl:when test="$layout = 'horizontal-counter'">
				<script type="text/javascript">
					<xsl:if test="$feature-twitter = 'true'">document.write("&lt;span class='st_twitter_hcount' displayText='Tweet'&gt;&lt;/span&gt;");</xsl:if>
					<xsl:if test="$feature-facebook = 'true'">document.write("&lt;span class='st_facebook_hcount' displayText='Share'&gt;&lt;/span&gt;");</xsl:if>
                    <xsl:if test="$feature-linkedin = 'true'">document.write("&lt;span class='st_linkedin_hcount' displayText='LinkedIn'&gt;&lt;/span&gt;");</xsl:if>
                    <xsl:if test="$feature-pinterest = 'true'">document.write("&lt;span class='st_pinterest_hcount' displayText='Pinterest'&gt;&lt;/span&gt;");</xsl:if>
					<xsl:if test="$feature-mail = 'true'">document.write("&lt;span class='st_email_hcount' displayText='Email'&gt;&lt;/span&gt;");</xsl:if>
					<xsl:if test="$feature-sharethis = 'true'">document.write("&lt;span class='st_sharethis_hcount' displayText='Share'&gt;&lt;/span&gt;");</xsl:if>
				</script>
			</xsl:when>
		</xsl:choose>
		
	</xsl:template>
    
    <xsl:template name="fb-lang">
        <xsl:param name="lang"/>
        <xsl:choose>
            <xsl:when test="$lang = 'fr'">fr_FR</xsl:when>
            <xsl:when test="$lang = 'en'">en_US</xsl:when>
            <xsl:when test="$lang = 'es'">es_ES</xsl:when>
            <xsl:when test="$lang = 'de'">de_DE</xsl:when>
            <xsl:when test="$lang = 'it'">it_IT</xsl:when>
            <xsl:when test="$lang = 'zh'">zh_CN</xsl:when>
        </xsl:choose>
    </xsl:template>
	
</xsl:stylesheet>
