/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.survey.actions;

import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.observation.AbstractNotifierAction;
import org.ametys.plugins.survey.dao.SurveyDAO;

/**
 * Action for retrieving the survey statistics, in order to sax them with a ActionResultGenerator.
 */
public class GetStatisticsAction extends AbstractNotifierAction
{
    private SurveyDAO _surveyDAO;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _surveyDAO = (SurveyDAO) serviceManager.lookup(SurveyDAO.ROLE);
    }
    
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        String surveyId = parameters.getParameter("surveyId", request.getParameter("surveyId"));
        
        Map<String, Object> result = _surveyDAO.getStatistics(surveyId);

        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        
        return EMPTY_MAP;
    }


}
