/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.survey.generators;

import java.io.IOException;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.survey.repository.SurveyPage;
import org.ametys.plugins.survey.repository.SurveyQuestion;
import org.ametys.plugins.survey.repository.SurveyQuestion.QuestionType;

/**
 * SAX page branching
 *
 */
public class PageBranchesGenerator extends QuestionRulesGenerator
{

    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        String id = request.getParameter("id");
        
        SurveyPage surveyPage = _resolver.resolveById(id);
        
        contentHandler.startDocument();
        
        AttributesImpl attr = new AttributesImpl();
        attr.addCDATAAttribute("id", surveyPage.getId());
        XMLUtils.startElement(contentHandler, "page", attr);
        
        AmetysObjectIterable<SurveyQuestion> questions = surveyPage.getChildren();
        int index = 1;
        for (SurveyQuestion question : questions)
        {
            if (question.getType() == QuestionType.SINGLE_CHOICE || question.getType() == QuestionType.MULTIPLE_CHOICE)
            {
                saxRules(question, index);
            }
            index++;
        }
        
        // SAX page rule
        saxRule(surveyPage);
        
        XMLUtils.endElement(contentHandler, "page");
        contentHandler.endDocument();
    }

}
