/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.survey.generators;

import java.io.IOException;
import java.util.List;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.plugins.survey.data.SurveySession;
import org.ametys.plugins.survey.repository.Survey;

/**
 * Generate all the user sessions with their answers for a given survey.
 */
public class SurveySessionsGenerator extends SurveySessionGenerator
{

    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        String surveyId = parameters.getParameter("id", request.getParameter("id"));
        
        Survey survey = _resolver.resolveById(surveyId);
        
        List<SurveySession> sessions = _surveyDao.getSessionsWithAnswers(surveyId);
        
        contentHandler.startDocument();
        
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("surveyId", surveyId);
        attrs.addCDATAAttribute("surveyTitle", survey.getTitle());
        
        XMLUtils.startElement(contentHandler, "survey-sessions", attrs);
        
        for (SurveySession surveySession : sessions)
        {
            saxSession(surveySession, survey, true);
        }
        
        XMLUtils.endElement(contentHandler, "survey-sessions");
        
        contentHandler.endDocument();
    }

}
