/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.tarteaucitron;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.core.util.dom.AmetysNodeList;
import org.ametys.core.util.dom.StringElement;
import org.ametys.runtime.config.Config;
import org.ametys.web.gdpr.GDPRService;
import org.ametys.web.gdpr.GDPRServicesExtensionPoint;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.NodeList;

public class TarteAuCitronXSLTHelper
implements Serviceable {
    protected static GDPRServicesExtensionPoint _gdprServicesEP;
    protected static SiteManager _siteManager;
    private static final Map<String, String> _TARTEAUCITRON_MAPPING;

    public void service(ServiceManager manager) throws ServiceException {
        _gdprServicesEP = (GDPRServicesExtensionPoint)manager.lookup(GDPRServicesExtensionPoint.ROLE);
        _siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
    }

    public static NodeList getServiceIds(String siteName) {
        ArrayList<StringElement> services = new ArrayList<StringElement>();
        Site site = _siteManager.getSite(siteName);
        List<String> serviceIds = TarteAuCitronXSLTHelper._getConfiguredServicesIds(site);
        if (!TarteAuCitronXSLTHelper._isConfigurationOverridden(site)) {
            serviceIds.addAll(TarteAuCitronXSLTHelper._getDefaultServiceIds(site));
        }
        for (String serviceId : serviceIds) {
            services.add(new StringElement("service", _TARTEAUCITRON_MAPPING.getOrDefault(serviceId, serviceId)));
        }
        return new AmetysNodeList(services);
    }

    protected static List<String> _getDefaultServiceIds(Site site) {
        ArrayList<String> serviceIds = new ArrayList<String>();
        List<GDPRService> gdprServices = _gdprServicesEP.getExtensionsIds().stream().map(id -> (GDPRService)_gdprServicesEP.getExtension(id)).collect(Collectors.toList());
        List tarteAuCitronServices = gdprServices.stream().filter(service -> service.getGDPRId().isPresent() && "gdpr.tarteaucitron".equals(service.getGDPRId().get())).collect(Collectors.toList());
        Optional<String> googleAnalyticsId = Optional.ofNullable(site).map(s -> (String)s.getValue("google-web-property-id")).filter(StringUtils::isNotBlank);
        Optional<String> googleMapsId = Optional.ofNullable(site).map(s -> (String)s.getValue("google-api-key")).filter(StringUtils::isNotBlank);
        for (GDPRService service2 : tarteAuCitronServices) {
            String serviceId = service2.getId();
            if (!("google-analytics".equals(serviceId) && googleAnalyticsId.isPresent() || "google-maps".equals(serviceId) && googleMapsId.isPresent() || "youtube-playlist".equals(serviceId) && googleMapsId.isPresent() && TarteAuCitronXSLTHelper._hasServiceEmptyGDPR(gdprServices, serviceId)) && !TarteAuCitronXSLTHelper._hasServiceEmptyGDPR(gdprServices, serviceId)) continue;
            serviceIds.add(_TARTEAUCITRON_MAPPING.getOrDefault(serviceId, serviceId));
        }
        return serviceIds;
    }

    private static boolean _hasServiceEmptyGDPR(List<GDPRService> gdprServices, String serviceId) {
        return gdprServices.stream().filter(service -> service.getId().equals(serviceId) && service.getGDPRId().isEmpty()).findAny().isPresent();
    }

    protected static boolean _isConfigurationOverridden(Site site) {
        String siteServices = (String)site.getValue("tarteaucitron-services");
        if (StringUtils.isNotBlank((CharSequence)siteServices)) {
            return (Boolean)site.getValue("tarteaucitron-override", false, (Object)false);
        }
        String services = (String)Config.getInstance().getValue("plugin.tarteaucitron.gdpr.param.services");
        return StringUtils.isNotBlank((CharSequence)services) && (Boolean)Config.getInstance().getValue("plugin.tarteaucitron.gdpr.param.override", false, (Object)false) != false;
    }

    protected static List<String> _getConfiguredServicesIds(Site site) {
        String services;
        String siteServices = (String)site.getValue("tarteaucitron-services");
        String string = services = StringUtils.isNotBlank((CharSequence)siteServices) ? siteServices : (String)Config.getInstance().getValue("plugin.tarteaucitron.gdpr.param.services");
        if (StringUtils.isNotBlank((CharSequence)services)) {
            return Stream.of(StringUtils.split((String)services, (String)",")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    static {
        _TARTEAUCITRON_MAPPING = Map.of("youtube", "youtube", "google-analytics", "gajs", "dailymotion", "dailymotion", "sharethis", "sharethis", "google-maps", "googlemaps", "google-calendar", "gagenda", "youtube-playlist", "youtubeplaylist", "matomo", "matomocloud");
    }
}

