<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:stringutils="org.apache.commons.lang.StringUtils"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    exclude-result-prefixes="ametys">

    <xsl:template name="google-analytics" >
        <xsl:variable name="webId" select="ametys:siteParameter('google-web-property-id')"/>
        
        <!-- Do not call GA on back or preview -->
        <xsl:if test="ametys:renderingContext() = 'front' and normalize-space($webId) != ''">
	        <script type="text/javascript">
	            tarteaucitron.user.gajsUa = '<xsl:value-of select="$webId" />';
	        </script>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
