<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:stringutils="org.apache.commons.lang.StringUtils"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    exclude-result-prefixes="ametys">

    <xsl:template name="google-maps-js" >
        <xsl:param name="uniqueId" />
        
        <script src="{ametys:pluginResourceURL('web', 'js/GmapViewer.js')}" type="text/javascript"></script>
        <script type="text/javascript">
            
            function initializeMap() 
            {
                let mapJquery = "<xsl:value-of select="ametys:pluginResourceURL('web', 'js/jquery.gmap.js')" />";
                tarteaucitron.addScript(mapJquery, null, setUpMap_<xsl:value-of select="$uniqueId" />);
            }
            
            tarteaucitron.user.googlemapsKey = '<xsl:value-of select="ametys:siteParameter('google-api-key')" />';
            tarteaucitron.user.mapscallback = 'initializeMap';
        </script>
    </xsl:template>

    <xsl:template name="google-maps-body" >
        <xsl:param name="uniqueId" />
        <xsl:param name="class" />
        <xsl:param name="mapTypeId" />
        <xsl:param name="zoomLevel" />
        <xsl:param name="latitude" />
        <xsl:param name="longitude" />
        <xsl:param name="height" />
        <xsl:param name="pointsOfInterest" />
        
        <!-- class 'googlemaps-canvas' is important for tarteaucitron -->
        <div  id="{$uniqueId}"
              class="googlemaps-canvas tarteaucitron {$class}" 
              zoom="{$zoomLevel}" 
              latitude="{$latitude}" 
              longitude="{$longitude}" 
              style="height: {$height}px">
        </div>
    </xsl:template>
    
</xsl:stylesheet>
