/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.ugc.enumerator;

import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.SourceResolver;

import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;

/**
 * {@link Enumerator} for workflow enumeration
 */
public class WorkflowEnumerator extends AbstractLogEnabled implements Enumerator<String>, Contextualizable, Serviceable
{
    private static final String __PREFIX_FILE = "ugc-";
    
    /** The cocoon context */
    protected org.apache.cocoon.environment.Context _context;
    
    /** the source resolver */
    protected SourceResolver _srcResolver;
    
    /** The workflow helper */
    protected WorkflowHelper _workflowHelper;
    
    @Override
    public void contextualize(Context context) throws ContextException 
    {
        _context = (org.apache.cocoon.environment.Context) context.get(org.apache.cocoon.Constants.CONTEXT_ENVIRONMENT_CONTEXT);
    }
    
    @Override
    public void service(ServiceManager manager) throws ServiceException 
    {
        _srcResolver = (SourceResolver) manager.lookup(SourceResolver.ROLE);
        _workflowHelper = (WorkflowHelper) manager.lookup(WorkflowHelper.ROLE);
    }
    
    @Override
    public Map<String, I18nizableText> getEntries() throws Exception
    {
        return _getThemes();
    }
    
    @Override
    public I18nizableText getEntry(String value) throws Exception
    {
        Map<String, I18nizableText> entries = _getWorkflows();
        return entries.get(value);
    }
    
    private Map<String, I18nizableText> _getThemes ()
    {
        return _getWorkflows();
    }
    
    /**
     * Retrieves the workflows begin by 'workflow-ugc'
     * @return The map of workflows
     */
    protected Map<String, I18nizableText> _getWorkflows()
    {
        Map<String, I18nizableText> workflows = new LinkedHashMap<>();
        
        for (String workflowName : _workflowHelper.getWorkflowNames())
        {
            if (StringUtils.startsWith(workflowName, __PREFIX_FILE))
            {
                workflows.put(workflowName, _workflowHelper.getWorkflowLabel(workflowName));
            }
        }
        
        return workflows;
    }
}
