/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.ugc.observation;

import javax.jcr.Session;

import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.web.cache.AbstractSiteCacheObserver;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;

/**
 * {@link Observer} for observing page creation or modification in order to
 * invalidate cache on front-office.
 */
public class InvalidateCacheOnContentPageModificationObserver extends AbstractSiteCacheObserver
{
    @Override
    public boolean supports(Event event)
    {
        return event.getId().equals(ObservationConstants.EVENT_UGC_ROOT_UPDATED);
    }
    
    @Override
    protected Site _getSite(Event event)
    {
        return _getPage(event).getSite();
    }
    
    private Page _getPage(Event event)
    {
        return (Page) event.getArguments().get(org.ametys.web.ObservationConstants.ARGS_PAGE);
    }
    
    @Override
    protected void _internalObserve(Event event, Site site, Session liveSession) throws Exception
    {
        Page page = _getPage(event);
        _cachePolicy.invalidateCacheOnPageModification(page);
    }
}
