/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.ugc.observation;

import java.util.Optional;

import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.plugins.ugc.page.UGCPage;
import org.ametys.web.repository.page.Page;

/**
 * Observes UGC content modified in order to synchronize the solr index.
 */
public class SolrContentModifiedObserver extends AbstractSolrContentAsyncObserver
{
    @Override
    public boolean supports(Event event)
    {
        return event.getId().equals(org.ametys.cms.ObservationConstants.EVENT_CONTENT_MODIFIED);
    }
    
    @Override
    protected void _internalObserve(Event event, Page rootContentPage, Content content)
    {
        Optional<UGCPage> contentPage = _getContentPage(rootContentPage, content);
        if (contentPage.isPresent())
        {
            try
            {
                // Reindex content page
                _solrPageIndexer.reindexPage(contentPage.get().getId(), RepositoryConstants.DEFAULT_WORKSPACE, true, false);
            }
            catch (Exception e)
            {
                getLogger().error("Failed to reindex page " + contentPage.get().getId(), e);
            }
        }
    }
}
