/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory;

import com.opensymphony.workflow.InvalidActionException;
import com.opensymphony.workflow.WorkflowException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.repository.data.holder.impl.DataHolderHelper;
import org.ametys.plugins.repository.data.holder.values.SynchronizableRepeater;
import org.ametys.plugins.userdirectory.AbstractDeleteUDContentComponent;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class DeleteUserComponent
extends AbstractDeleteUDContentComponent {
    public static final String ROLE = DeleteUserComponent.class.getName();
    protected UserDirectoryHelper _udHelper;
    protected ContentHelper _contentHelper;
    protected ContentWorkflowHelper _contentWorkflowHelper;
    protected I18nUtils _i18nUtils;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._udHelper = (UserDirectoryHelper)((Object)smanager.lookup(UserDirectoryHelper.ROLE));
        this._contentHelper = (ContentHelper)smanager.lookup(ContentHelper.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
        this._contentWorkflowHelper = (ContentWorkflowHelper)smanager.lookup(ContentWorkflowHelper.ROLE);
    }

    @Override
    public boolean isContentReferenced(Content content, Logger logger) {
        return this._contentHelper.hasReferencingContents(content, Collections.singletonList("org.ametys.plugins.userdirectory.Content.udorgunit"), false);
    }

    @Override
    protected boolean _checkBeforeDeletion(Content content, Map<String, String> rights, Map<String, Object> results, Logger logger) {
        boolean allRight = this._canDeleteContent(content, rights, results);
        allRight = this._checkOrgUnitsBeforeDeletion(content, results) && allRight;
        return allRight;
    }

    protected boolean _checkOrgUnitsBeforeDeletion(Content content, Map<String, Object> results) {
        boolean allRight = true;
        List<Content> orgUnits = this._udHelper.getOrgUnits(content);
        for (Content orgUnit : orgUnits) {
            if (!this._isLocked(orgUnit)) continue;
            List lockedContents = (List)results.get("locked-contents");
            lockedContents.add(orgUnit);
            allRight = false;
        }
        return allRight;
    }

    @Override
    protected boolean _removeRelations(Content content, Map<String, Object> parameters, Logger logger) {
        boolean success = true;
        List incomingReferences = this._contentHelper.getReferencingContents(content);
        for (Pair reference : incomingReferences) {
            String valuePath = (String)reference.getLeft();
            Content orgUnit = (Content)reference.getRight();
            try {
                I18nizableText commentText = new I18nizableText("plugin.user-directory", "PLUGINS_USER_DIRECTORY_WORKFLOW_ACTION_REMOVE_USER_REFERENCE_MSG");
                String comment = this._i18nUtils.translate((I18nizable)commentText, orgUnit.getLanguage());
                this._removeRelation((WorkflowAwareContent)orgUnit, valuePath, comment);
            }
            catch (InvalidActionException | WorkflowException e) {
                logger.error("Unable to remove relation to content \"{}\" ({}) for referencing content \"{}\" ({}) ", new Object[]{content.getTitle(), content.getId(), orgUnit.getTitle(), orgUnit.getId(), e});
                success = false;
            }
        }
        return success;
    }

    private void _removeRelation(WorkflowAwareContent orgUnit, String valuePath, String comment) throws WorkflowException {
        String entryPath = StringUtils.substringBeforeLast((String)valuePath, (String)"/");
        int position = (Integer)DataHolderHelper.getRepeaterNameAndEntryPosition((String)entryPath).getRight();
        SynchronizableRepeater repeater = SynchronizableRepeater.appendOrRemove(List.of(), Set.of(Integer.valueOf(position)));
        Map<String, SynchronizableRepeater> values = Map.of("users", repeater);
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            inputs.put("comment", comment);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("typedValues", values);
        parameters.put("quit", true);
        inputs.put(AbstractWorkflowComponent.CONTEXT_PARAMETERS_KEY, parameters);
        this._contentWorkflowHelper.doAction(orgUnit, this._removeReferenceActionId, inputs);
    }

    @Override
    protected Set<String> _getContentIdsToDelete(Content content, Map<String, Object> parameters, Map<String, String> rights, Map<String, Object> results, Logger logger) {
        return Collections.singleton(content.getId());
    }
}

