/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.SortCriteria;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.MetadataExpression;
import org.ametys.plugins.repository.query.expression.NotExpression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.repository.query.expression.VirtualFactoryExpression;
import org.ametys.plugins.userdirectory.page.VirtualOrganisationChartPageFactory;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageQueryHelper;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang.StringUtils;

public class OrganisationChartPageHandler
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = OrganisationChartPageHandler.class.getName();
    public static final String ORGUNIT_CONTENT_TYPE = "org.ametys.plugins.userdirectory.Content.udorgunit";
    public static final String PARENT_ORGUNIT_ATTRIBUTE_NAME = "parentOrgUnit";
    public static final String CHILD_ORGUNIT_ATTRIBUTE_NAME = "childOrgUnits";
    public static final String ORGUNIT_USERS_ATTRIBUTE_NAME = "users";
    public static final String ORGUNIT_USER_ATTRIBUTE_NAME = "user";
    public static final String ORGUNIT_USER_ROLE_ATTRIBUTE_NAME = "role";
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public AmetysObjectIterable<Content> getContentsForRootPage(Page rootPage) {
        String lang = rootPage.getSitemapName();
        return this.getFirstLevelOfContents(lang);
    }

    public AmetysObjectIterable<Content> getFirstLevelOfContents(String lang) {
        ContentTypeExpression contentTypeExp = new ContentTypeExpression(Expression.Operator.EQ, new String[]{ORGUNIT_CONTENT_TYPE});
        MetadataExpression parentMetadataExpression = new MetadataExpression(PARENT_ORGUNIT_ATTRIBUTE_NAME);
        OrExpression noParentExpression = new OrExpression(new Expression[]{new NotExpression((Expression)parentMetadataExpression), new StringExpression(PARENT_ORGUNIT_ATTRIBUTE_NAME, Expression.Operator.EQ, "")});
        AndExpression finalExpr = new AndExpression(new Expression[]{noParentExpression, contentTypeExp, new LanguageExpression(Expression.Operator.EQ, lang)});
        SortCriteria sort = new SortCriteria();
        sort.addCriterion("title", true, true);
        String xPathQuery = QueryHelper.getXPathQuery(null, (String)"ametys:content", (Expression)finalExpr, (SortCriteria)sort);
        return this._resolver.query(xPathQuery);
    }

    public boolean isOrganisationChartRootPage(JCRAmetysObject jcrPage) {
        try {
            Node node = jcrPage.getNode();
            if (node.hasProperty("ametys-internal:virtual")) {
                List<Value> values = Arrays.asList(node.getProperty("ametys-internal:virtual").getValues());
                return values.stream().map(LambdaUtils.wrap(Value::getString)).anyMatch(v -> VirtualOrganisationChartPageFactory.class.getName().equals(v));
            }
            return false;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public List<Content> getChildContents(Content parentContent) {
        ArrayList<Content> contentList = new ArrayList<Content>();
        ContentValue[] contents = (ContentValue[])parentContent.getValue(CHILD_ORGUNIT_ATTRIBUTE_NAME);
        if (contents != null) {
            for (ContentValue content : contents) {
                try {
                    contentList.add((Content)content.getContent());
                }
                catch (UnknownAmetysObjectException e) {
                    this.getLogger().warn("The parent entity {} ({}) is referencing an unexisting child node '{}'", new Object[]{parentContent.getTitle(), parentContent.getId(), content.getContentId(), e});
                }
            }
        }
        contentList.sort(Comparator.comparingLong(c -> (Long)c.getValue("order", false, (Object)Long.MAX_VALUE)).thenComparing(c -> c.getTitle().toLowerCase(), Comparator.naturalOrder()));
        return contentList;
    }

    public Content getParentContent(Content childContent) {
        ContentValue content = (ContentValue)childContent.getValue(PARENT_ORGUNIT_ATTRIBUTE_NAME);
        if (content != null) {
            try {
                return content.getContent();
            }
            catch (UnknownAmetysObjectException e) {
                this.getLogger().warn("There is no parent content with id " + content.getContentId(), (Throwable)e);
            }
        }
        return null;
    }

    public List<Content> getUserContents(Content content) {
        ArrayList<Content> users = new ArrayList<Content>();
        ContentValue[] contents = (ContentValue[])content.getValue("users/user", true);
        if (contents != null) {
            for (ContentValue contentValue : contents) {
                try {
                    users.add((Content)contentValue.getContent());
                }
                catch (Exception e) {
                    this.getLogger().warn("The entity {} ({}) is referencing an unexisting user content node '{}'", new Object[]{content.getTitle(), content.getId(), contentValue.getContentId(), e});
                }
            }
        }
        return users;
    }

    public Content getChildFromPath(Content parentContent, String path) {
        String contentName = path.contains("/") ? StringUtils.substringBefore((String)path, (String)"/") : path;
        List<Content> childContents = this.getChildContents(parentContent);
        List contentFilter = childContents.stream().filter(c -> c.getName().equals(contentName)).collect(Collectors.toList());
        if (!contentFilter.isEmpty()) {
            if (path.contains("/")) {
                return this.getChildFromPath((Content)contentFilter.get(0), StringUtils.substringAfter((String)path, (String)"/"));
            }
            return (Content)contentFilter.get(0);
        }
        return null;
    }

    public Page getOrganisationChartRootPages(String siteName, String sitemapName) throws AmetysRepositoryException {
        VirtualFactoryExpression expression = new VirtualFactoryExpression(VirtualOrganisationChartPageFactory.class.getName());
        String query = PageQueryHelper.getPageXPathQuery((String)siteName, (String)sitemapName, null, (Expression)expression, null);
        AmetysObjectIterable pages = this._resolver.query(query);
        return pages.iterator().hasNext() ? (Page)pages.iterator().next() : null;
    }
}

