/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.cms.data.ExplorerFile;
import org.ametys.cms.data.File;
import org.ametys.cms.repository.Content;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class GetProfileImageUriAction
extends ServiceableAction {
    public static final String USER_CONTENT_IMAGE_PATH = "illustration/image";
    protected CurrentUserProvider _currentUserProvider;
    protected UserDirectoryHelper _userDirectoryHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(this.manager);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._userDirectoryHelper = (UserDirectoryHelper)((Object)smanager.lookup(UserDirectoryHelper.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        UserIdentity user = this._getUser(parameters);
        int size = parameters.getParameterAsInteger("size", 0);
        int maxSize = parameters.getParameterAsInteger("maxSize", 0);
        boolean download = parameters.getParameterAsBoolean("download", false);
        String lang = parameters.getParameter("lang");
        result.put("imageUri", this._getProfileImageUri(user, lang, size, maxSize, download));
        return result;
    }

    protected String _getProfileImageUri(UserIdentity user, String lang, int size, int maxSize, boolean download) {
        if (user == null) {
            return this._getDefaultImageUriForAnonymous(size, maxSize, download);
        }
        String imageUri = this._getImageUriFromUserContent(user, lang, size, maxSize, download);
        if (imageUri == null) {
            imageUri = this._getDefaultImageUri(user, lang, size, maxSize, download);
        }
        return imageUri;
    }

    protected String _getDefaultImageUriForAnonymous(int size, int maxSize, boolean download) {
        return "skin://resources/img/avatar.png";
    }

    protected String _getImageUriFromUserContent(UserIdentity user, String lang, int size, int maxSize, boolean download) {
        Content userContent = this._userDirectoryHelper.getUserContent(user, lang);
        if (userContent != null && userContent.hasValue(USER_CONTENT_IMAGE_PATH)) {
            File fileValue = (File)userContent.getValue(USER_CONTENT_IMAGE_PATH);
            if (fileValue instanceof ExplorerFile) {
                return ResolveURIComponent.resolveCroppedImage((String)"explorer", (String)((ExplorerFile)fileValue).getResourceId(), (int)size, (int)size, (boolean)download, (boolean)false, (boolean)true);
            }
            String imgUri = "illustration/image?contentId=" + userContent.getId();
            return ResolveURIComponent.resolveCroppedImage((String)"attribute", (String)imgUri, (int)size, (int)size, (boolean)download, (boolean)false, (boolean)true);
        }
        return null;
    }

    protected String _getDefaultImageUri(UserIdentity user, String lang, int size, int maxSize, boolean download) {
        StringBuilder sb = new StringBuilder("cocoon://_plugins/core-ui/user/");
        sb.append(user.getPopulationId()).append("/").append(user.getLogin()).append("/image_").append(size);
        ArrayList<Object> params = new ArrayList<Object>();
        if (download) {
            params.add("download=true");
        }
        if (maxSize > 0) {
            params.add("maxSize=" + maxSize);
        }
        if (params.size() > 0) {
            sb.append("?").append(String.join((CharSequence)"&", params));
        }
        return sb.toString();
    }

    protected UserIdentity _getUser(Parameters parameters) {
        String login = parameters.getParameter("login", "");
        String populationId = parameters.getParameter("populationId", "");
        if (StringUtils.isEmpty((CharSequence)login) || StringUtils.isEmpty((CharSequence)populationId)) {
            return this._currentUserProvider.getUser();
        }
        return new UserIdentity(login, populationId);
    }
}

