/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.clientsideelement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.userdirectory.OrganisationChartPageHandler;
import org.ametys.plugins.userdirectory.page.VirtualOrganisationChartPageFactory;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.clientsideelement.AbstractPageClientSideElement;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.jackrabbit.value.StringValue;

public class SetOrganisationChartRootClientSideElement
extends AbstractPageClientSideElement {
    protected ObservationManager _observationManager;
    protected OrganisationChartPageHandler _pageHandler;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._observationManager = (ObservationManager)smanager.lookup(ObservationManager.ROLE);
        this._pageHandler = (OrganisationChartPageHandler)((Object)smanager.lookup(OrganisationChartPageHandler.ROLE));
    }

    @Callable
    public Map<String, Object> getStatus(String pageId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map parameters = this._script.getParameters();
        Page page = (Page)this._resolver.resolveById(pageId);
        if (page instanceof JCRAmetysObject) {
            if (this._pageHandler.isOrganisationChartRootPage((JCRAmetysObject)page)) {
                ArrayList<String> i18nParameters = new ArrayList<String>();
                i18nParameters.add(page.getTitle());
                I18nizableText ed = (I18nizableText)parameters.get("organisation-chart-page-description");
                I18nizableText msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
                result.put("organisation-chart-page-title", msg);
                ed = (I18nizableText)parameters.get("remove-organisation-chart-page-description");
                msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
                result.put("remove-organisation-chart-page-title", msg);
                result.put("organisation-chart-page-id", new I18nizableText(page.getId()));
            } else if (this._pageHandler.getOrganisationChartRootPages(page.getSiteName(), page.getSitemapName()) != null) {
                I18nizableText ed = (I18nizableText)parameters.get("organisation-chart-root-already-exist");
                result.put("organisation-chart-root-already-exist", ed);
            } else {
                ArrayList<String> i18nParameters = new ArrayList<String>();
                i18nParameters.add(page.getTitle());
                I18nizableText ed = (I18nizableText)parameters.get("add-organisation-chart-page-description");
                I18nizableText msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
                result.put("add-organisation-chart-page-id", new I18nizableText(page.getId()));
                result.put("add-organisation-chart-page-title", msg);
            }
        } else {
            ArrayList<String> noJcrI18nParameters = new ArrayList<String>();
            noJcrI18nParameters.add(page.getTitle());
            I18nizableText ed = (I18nizableText)parameters.get("no-jcr-page-description");
            I18nizableText msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), noJcrI18nParameters);
            result.put("no-jcr-page-id", new I18nizableText(page.getId()));
            result.put("no-jcr-page-title", msg);
        }
        return result;
    }

    @Callable
    public Map<String, Object> setOrganisationChartRoot(String pageId) throws RepositoryException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = (Page)this._resolver.resolveById(pageId);
        if (this._pageHandler.getOrganisationChartRootPages(page.getSiteName(), page.getSitemapName()) != null) {
            result.put("error", "already-exist");
            return result;
        }
        HashMap<String, Page> eventParams = new HashMap<String, Page>();
        eventParams.put("page", page);
        this._addOrganisationChartRootProperty(page);
        this._notifyPageUpdated(page);
        this._observationManager.notify(new Event("organisation.chart.root.updated", this._currentUserProvider.getUser(), eventParams));
        return result;
    }

    @Callable
    public Map<String, Object> removeOrganisationChartRoot(String pageId) throws RepositoryException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = (Page)this._resolver.resolveById(pageId);
        if (page instanceof JCRAmetysObject) {
            if (!this._pageHandler.isOrganisationChartRootPage((JCRAmetysObject)page)) {
                result.put("error", "no-root");
                return result;
            }
            HashMap<String, Page> eventParams = new HashMap<String, Page>();
            eventParams.put("page", page);
            this._observationManager.notify(new Event("organisation.chart.root.deleting", this._currentUserProvider.getUser(), eventParams));
            this._removeUserDirectoryRootProperty(page);
            this._notifyPageUpdated(page);
            this._observationManager.notify(new Event("organisation.chart.root.deleted", this._currentUserProvider.getUser(), eventParams));
        } else {
            result.put("error", "no-root");
        }
        return result;
    }

    private void _addOrganisationChartRootProperty(Page page) throws RepositoryException {
        if (page instanceof JCRAmetysObject) {
            StringValue virtualUserDirectoryPageFactoryClassName;
            JCRAmetysObject jcrPage = (JCRAmetysObject)page;
            Node node = jcrPage.getNode();
            ArrayList<Object> values = new ArrayList<Object>();
            if (node.hasProperty("ametys-internal:virtual")) {
                values.addAll(Arrays.asList(node.getProperty("ametys-internal:virtual").getValues()));
            }
            if (!values.contains(virtualUserDirectoryPageFactoryClassName = new StringValue(VirtualOrganisationChartPageFactory.class.getName()))) {
                values.add(virtualUserDirectoryPageFactoryClassName);
            }
            node.setProperty("ametys-internal:virtual", values.toArray(new Value[values.size()]));
            jcrPage.saveChanges();
        }
    }

    private void _removeUserDirectoryRootProperty(Page page) throws RepositoryException {
        JCRAmetysObject jcrPage;
        Node node;
        if (page instanceof JCRAmetysObject && (node = (jcrPage = (JCRAmetysObject)page).getNode()).hasProperty("ametys-internal:virtual")) {
            ArrayList<Value> values = new ArrayList<Value>(Arrays.asList(node.getProperty("ametys-internal:virtual").getValues()));
            int index = values.stream().map(LambdaUtils.wrap(Value::getString)).collect(Collectors.toList()).indexOf(VirtualOrganisationChartPageFactory.class.getName());
            if (index != -1) {
                values.remove(index);
                node.setProperty("ametys-internal:virtual", values.toArray(new Value[values.size()]));
            }
            jcrPage.saveChanges();
        }
    }

    private void _notifyPageUpdated(Page page) {
        HashMap<String, Page> eventParams = new HashMap<String, Page>();
        eventParams.put("page", page);
        this._observationManager.notify(new Event("page.updated", this._currentUserProvider.getUser(), eventParams));
    }
}

