/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.clientsideelement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.userdirectory.UserDirectoryPageHandler;
import org.ametys.plugins.userdirectory.page.VirtualUserDirectoryPageFactory;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.clientsideelement.AbstractPageClientSideElement;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.value.StringValue;

public class SetUserDirectoryRootClientSideElement
extends AbstractPageClientSideElement {
    protected ObservationManager _observationManager;
    protected ContentTypeExtensionPoint _contentTypeEP;
    protected UserDirectoryPageHandler _userDirectoryPageHandler;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._observationManager = (ObservationManager)smanager.lookup(ObservationManager.ROLE);
        this._contentTypeEP = (ContentTypeExtensionPoint)smanager.lookup(ContentTypeExtensionPoint.ROLE);
        this._userDirectoryPageHandler = (UserDirectoryPageHandler)((Object)smanager.lookup(UserDirectoryPageHandler.ROLE));
    }

    @Callable
    public Map<String, Object> getStatus(String pageId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map parameters = this._script.getParameters();
        Page page = (Page)this._resolver.resolveById(pageId);
        if (page instanceof JCRAmetysObject) {
            if (this._isUserDirectoryRootPage((JCRAmetysObject)page)) {
                ArrayList<String> i18nParameters = new ArrayList<String>();
                i18nParameters.add(page.getTitle());
                I18nizableText ed = (I18nizableText)parameters.get("user-directory-page-description");
                I18nizableText msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
                result.put("user-directory-page-title", msg);
                ed = (I18nizableText)parameters.get("remove-user-directory-page-description");
                msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
                result.put("remove-user-directory-page-title", msg);
                String contentTypeId = (String)page.getValue("user-directory-root-contenttype", (Object)"");
                if (StringUtils.isNotEmpty((CharSequence)contentTypeId)) {
                    I18nizableText contentTypeText = this._contentTypeEP.hasExtension(contentTypeId) ? ((ContentType)this._contentTypeEP.getExtension(contentTypeId)).getLabel() : new I18nizableText(contentTypeId);
                    HashMap<String, I18nizableText> contentTypeI18nParameters = new HashMap<String, I18nizableText>();
                    contentTypeI18nParameters.put("0", contentTypeText);
                    ed = (I18nizableText)parameters.get("contenttype-user-directory-page-description");
                    msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), contentTypeI18nParameters);
                    result.put("contenttype-user-directory-page-description", msg);
                }
                result.put("user-directory-page-id", new I18nizableText(page.getId()));
                I18nizableText defaultDirectoryDeep = (I18nizableText)parameters.get("default-depth");
                long depthData = (Long)page.getValue("user-directory-root-depth", (Object)-1L);
                I18nizableText depth = depthData == -1L ? defaultDirectoryDeep : new I18nizableText(String.valueOf(depthData));
                result.put("depth", depth);
            } else {
                ArrayList<String> i18nParameters = new ArrayList<String>();
                i18nParameters.add(page.getTitle());
                I18nizableText ed = (I18nizableText)parameters.get("add-user-directory-page-description");
                I18nizableText msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
                result.put("add-user-directory-page-id", new I18nizableText(page.getId()));
                result.put("add-user-directory-page-title", msg);
            }
        } else {
            ArrayList<String> noJcrI18nParameters = new ArrayList<String>();
            noJcrI18nParameters.add(page.getTitle());
            I18nizableText ed = (I18nizableText)parameters.get("no-jcr-page-description");
            I18nizableText msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), noJcrI18nParameters);
            result.put("no-jcr-page-id", new I18nizableText(page.getId()));
            result.put("no-jcr-page-title", msg);
        }
        return result;
    }

    private boolean _isUserDirectoryRootPage(JCRAmetysObject jcrPage) {
        try {
            Node node = jcrPage.getNode();
            if (node.hasProperty("ametys-internal:virtual")) {
                List<Value> values = Arrays.asList(node.getProperty("ametys-internal:virtual").getValues());
                return values.stream().map(LambdaUtils.wrap(Value::getString)).anyMatch(v -> VirtualUserDirectoryPageFactory.class.getName().equals(v));
            }
            return false;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Callable
    public List<Map<String, Object>> getSupportedContentTypes(String pageId) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Page page = (Page)this._resolver.resolveById(pageId);
        for (String contentTypeId : this._contentTypeEP.getSubTypes("org.ametys.plugins.userdirectory.Content.user")) {
            ContentType contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
            Page userDirectoryRootPage = this._userDirectoryPageHandler.getUserDirectoryRootPage(page.getSiteName(), page.getSitemapName(), contentTypeId);
            if (contentType.isAbstract() || userDirectoryRootPage != null && !userDirectoryRootPage.equals(page)) continue;
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("value", contentType.getId());
            entry.put("text", (String)contentType.getLabel());
            result.add(entry);
        }
        return result;
    }

    @Callable
    public Map<String, Object> setUserDirectoryRoot(String pageId, String contentType, String viewName, String attribute, int depth) throws RepositoryException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this._contentTypeEP.isDescendant(contentType, "org.ametys.plugins.userdirectory.Content.user")) {
            result.put("error", "invalid-content-type");
            return result;
        }
        Page page = (Page)this._resolver.resolveById(pageId);
        String oldContentType = (String)page.getValue("user-directory-root-contenttype", (Object)"");
        String oldAttribute = (String)page.getValue("user-directory-root-classification-metadata", (Object)"");
        String oldViewName = (String)page.getValue("user-directory-root-view-name", (Object)"");
        long oldDepth = (Long)page.getValue("user-directory-root-depth", (Object)-1L);
        if (!(oldContentType.equals(contentType) && oldAttribute.equals(attribute) && oldDepth == (long)depth && oldViewName.equals(viewName))) {
            Set<Page> currentUserDirectoryPages = this._userDirectoryPageHandler.getUserDirectoryRootPages(page.getSiteName(), page.getSitemapName());
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("page", page);
            if (currentUserDirectoryPages.contains(page)) {
                eventParams.put("user.content.view.updated", !oldViewName.equals(viewName));
                this._observationManager.notify(new Event("user.directory.root.updating", this._currentUserProvider.getUser(), eventParams));
                this._updateUserDirectoryRootProperty(page, contentType, viewName, attribute, depth);
            } else {
                this._addUserDirectoryRootProperty(page, contentType, viewName, attribute, depth);
            }
            this._userDirectoryPageHandler.clearCache(page);
            this._notifyPageUpdated(page);
            this._observationManager.notify(new Event("user.directory.root.updated", this._currentUserProvider.getUser(), eventParams));
        }
        return result;
    }

    @Callable
    public Map<String, Object> removeUserDirectoryRoot(String pageId) throws RepositoryException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = (Page)this._resolver.resolveById(pageId);
        if (page instanceof JCRAmetysObject) {
            if (!this._isUserDirectoryRootPage((JCRAmetysObject)page)) {
                result.put("error", "no-root");
                return result;
            }
            HashMap<String, Page> eventParams = new HashMap<String, Page>();
            eventParams.put("page", page);
            this._observationManager.notify(new Event("user.directory.root.deleting", this._currentUserProvider.getUser(), eventParams));
            this._userDirectoryPageHandler.clearCache(page);
            this._removeUserDirectoryRootProperty(page);
            this._notifyPageUpdated(page);
            this._observationManager.notify(new Event("user.directory.root.deleted", this._currentUserProvider.getUser(), eventParams));
        } else {
            result.put("error", "no-root");
        }
        return result;
    }

    @Callable
    public Map<String, Object> getRootPageInfo(String pageId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = (Page)this._resolver.resolveById(pageId);
        Set<Page> currentUserDirectoryPages = this._userDirectoryPageHandler.getUserDirectoryRootPages(page.getSiteName(), page.getSitemapName());
        if (currentUserDirectoryPages.contains(page)) {
            result.put("isRoot", true);
            result.put("contentType", page.getValue("user-directory-root-contenttype"));
            result.put("viewName", page.getValue("user-directory-root-view-name", (Object)""));
            result.put("metadata", page.getValue("user-directory-root-classification-metadata"));
            result.put("depth", page.getValue("user-directory-root-depth"));
        } else {
            result.put("isRoot", false);
        }
        return result;
    }

    private void _addUserDirectoryRootProperty(Page page, String contentType, String viewName, String attribute, int depth) throws RepositoryException {
        if (page instanceof JCRAmetysObject) {
            StringValue virtualUserDirectoryPageFactoryClassName;
            JCRAmetysObject jcrPage = (JCRAmetysObject)page;
            Node node = jcrPage.getNode();
            ArrayList<Object> values = new ArrayList<Object>();
            if (node.hasProperty("ametys-internal:virtual")) {
                values.addAll(Arrays.asList(node.getProperty("ametys-internal:virtual").getValues()));
            }
            if (!values.contains(virtualUserDirectoryPageFactoryClassName = new StringValue(VirtualUserDirectoryPageFactory.class.getName()))) {
                values.add(virtualUserDirectoryPageFactoryClassName);
            }
            node.setProperty("ametys-internal:virtual", values.toArray(new Value[values.size()]));
            if (page instanceof ModifiablePage) {
                ModifiablePage modifiablePage = (ModifiablePage)page;
                modifiablePage.setValue("user-directory-root-contenttype", (Object)contentType);
                modifiablePage.setValue("user-directory-root-view-name", (Object)viewName);
                modifiablePage.setValue("user-directory-root-classification-metadata", (Object)attribute);
                modifiablePage.setValue("user-directory-root-depth", (Object)depth);
            }
            jcrPage.saveChanges();
        }
    }

    private void _updateUserDirectoryRootProperty(Page page, String contentType, String viewName, String attribute, int depth) {
        if (page instanceof ModifiablePage) {
            ModifiablePage modifiablePage = (ModifiablePage)page;
            modifiablePage.setValue("user-directory-root-contenttype", (Object)contentType);
            modifiablePage.setValue("user-directory-root-view-name", (Object)viewName);
            modifiablePage.setValue("user-directory-root-classification-metadata", (Object)attribute);
            modifiablePage.setValue("user-directory-root-depth", (Object)depth);
            modifiablePage.saveChanges();
        }
    }

    private void _removeUserDirectoryRootProperty(Page page) throws RepositoryException {
        JCRAmetysObject jcrPage;
        Node node;
        if (page instanceof JCRAmetysObject && (node = (jcrPage = (JCRAmetysObject)page).getNode()).hasProperty("ametys-internal:virtual")) {
            ArrayList<Value> values = new ArrayList<Value>(Arrays.asList(node.getProperty("ametys-internal:virtual").getValues()));
            int index = values.stream().map(LambdaUtils.wrap(Value::getString)).collect(Collectors.toList()).indexOf(VirtualUserDirectoryPageFactory.class.getName());
            if (index != -1) {
                values.remove(index);
                node.setProperty("ametys-internal:virtual", values.toArray(new Value[values.size()]));
            }
            if (page instanceof ModifiablePage) {
                ModifiablePage modifiablePage = (ModifiablePage)page;
                modifiablePage.removeValue("user-directory-root-contenttype");
                modifiablePage.removeValue("user-directory-root-view-name");
                modifiablePage.removeValue("user-directory-root-classification-metadata");
                modifiablePage.removeValue("user-directory-root-depth");
            }
            jcrPage.saveChanges();
        }
    }

    private void _notifyPageUpdated(Page page) {
        HashMap<String, Page> eventParams = new HashMap<String, Page>();
        eventParams.put("page", page);
        this._observationManager.notify(new Event("page.changed", this._currentUserProvider.getUser(), eventParams));
    }
}

