/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.observation;

import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.userdirectory.UserDirectoryPageHandler;
import org.ametys.plugins.userdirectory.page.UserDirectoryPageResolver;
import org.ametys.plugins.userdirectory.page.UserZoneItem;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.cache.pageelement.PageElementCache;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class InvalidateZoneItemCacheOnRootUpdatedObserver
extends AbstractLogEnabled
implements Observer,
Serviceable {
    private UserDirectoryPageHandler _udPageHandler;
    private UserDirectoryPageResolver _udPageResolver;
    private PageElementCache _zoneItemCache;

    public void service(ServiceManager smanager) throws ServiceException {
        this._udPageHandler = (UserDirectoryPageHandler)((Object)smanager.lookup(UserDirectoryPageHandler.ROLE));
        this._zoneItemCache = (PageElementCache)smanager.lookup(PageElementCache.ROLE + "/zoneItem");
        this._udPageResolver = (UserDirectoryPageResolver)((Object)smanager.lookup(UserDirectoryPageResolver.ROLE));
    }

    public boolean supports(Event event) {
        return event.getId().equals("user.directory.root.updated");
    }

    public int getPriority(Event event) {
        return 3500;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Page rootPage = (Page)event.getArguments().get("page");
        boolean viewUpdated = (Boolean)event.getArguments().get("user.content.view.updated");
        if (viewUpdated) {
            AmetysObjectIterable<Content> userContents = this._udPageHandler.getContentsForRootPage(rootPage);
            for (Content content : userContents) {
                this._removeZoneItemCache(rootPage, content);
            }
        }
    }

    private void _removeZoneItemCache(Page rootPage, Content content) {
        String userPageId = this._udPageResolver.getUserPageId(rootPage, content);
        String zoneItemId = UserZoneItem.getZoneItemId(userPageId);
        this._zoneItemCache.removeItem(null, rootPage.getSiteName(), "CONTENT", zoneItemId);
    }
}

