/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.MemoryRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.userdirectory.OrganisationChartPageHandler;
import org.ametys.plugins.userdirectory.page.OrgUnitZone;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.UnknownZoneException;
import org.ametys.web.repository.page.Zone;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinsManager;
import org.apache.commons.lang.StringUtils;

public class OrgUnitPage
implements Page {
    private static final String __ORGUNIT_PAGE_TEMPLATE = "udorgunit";
    private Page _root;
    private String _title;
    private AmetysObjectResolver _resolver;
    private OrganisationChartPageHandler _organisationChartPageHandler;
    private SynchronizableContentsCollectionDAO _syncContentsCollectionDAO;
    private SkinsManager _skinsManager;
    private String _path;
    private Content _syncContent;
    private org.ametys.web.data.type.ModelItemTypeExtensionPoint _pageDataTypeExtensionPoint;
    private org.ametys.web.data.type.ModelItemTypeExtensionPoint _zoneDataTypeExtensionPoint;
    private org.ametys.web.data.type.ModelItemTypeExtensionPoint _zoneItemDataTypeExtensionPoint;

    public OrgUnitPage(Page root, Content syncContent, String path, AmetysObjectResolver resolver, OrganisationChartPageHandler organisationChartPageHandler, SynchronizableContentsCollectionDAO syncContentsCollectionDAO, SkinsManager skinsManager, org.ametys.web.data.type.ModelItemTypeExtensionPoint pageDataTypeExtensionPoint, org.ametys.web.data.type.ModelItemTypeExtensionPoint zoneDataTypeExtensionPoint, org.ametys.web.data.type.ModelItemTypeExtensionPoint zoneItemDataTypeExtensionPoint) {
        this._root = root;
        this._path = path;
        this._resolver = resolver;
        this._organisationChartPageHandler = organisationChartPageHandler;
        this._syncContentsCollectionDAO = syncContentsCollectionDAO;
        this._skinsManager = skinsManager;
        this._syncContent = syncContent;
        this._title = this._syncContent.getTitle(new Locale(root.getSitemapName()));
        this._pageDataTypeExtensionPoint = pageDataTypeExtensionPoint;
        this._zoneDataTypeExtensionPoint = zoneDataTypeExtensionPoint;
        this._zoneItemDataTypeExtensionPoint = zoneItemDataTypeExtensionPoint;
    }

    public Content getSyncContent() {
        return this._syncContent;
    }

    public int getDepth() throws AmetysRepositoryException {
        return this._root.getDepth() + (this._path != null ? this._path.split("/").length : 0);
    }

    public Set<String> getReferers() throws AmetysRepositoryException {
        return null;
    }

    public ResourceCollection getRootAttachments() throws AmetysRepositoryException {
        return null;
    }

    public String getTemplate() throws AmetysRepositoryException {
        Skin skin = this._skinsManager.getSkin(this.getSite().getSkinId());
        if (skin.getTemplate(__ORGUNIT_PAGE_TEMPLATE) != null) {
            return __ORGUNIT_PAGE_TEMPLATE;
        }
        return "page";
    }

    public String getTitle() throws AmetysRepositoryException {
        return this._title;
    }

    public String getLongTitle() throws AmetysRepositoryException {
        return this._title;
    }

    public Page.PageType getType() throws AmetysRepositoryException {
        return Page.PageType.CONTAINER;
    }

    public String getURL() throws AmetysRepositoryException {
        throw new UnsupportedOperationException("#getURL is not supported on virtual orgUnit pages");
    }

    public Page.LinkType getURLType() throws AmetysRepositoryException {
        throw new UnsupportedOperationException("#getURLType is not supported on virtual orgUnit pages");
    }

    public Zone getZone(String name) throws UnknownZoneException, AmetysRepositoryException {
        if (!"default".equals(name)) {
            throw new IllegalArgumentException("Only the zone named 'default' is actually supported on virtual orgUnit pages.");
        }
        return new OrgUnitZone(this, this._zoneDataTypeExtensionPoint, this._zoneItemDataTypeExtensionPoint);
    }

    public AmetysObjectIterable<? extends Zone> getZones() throws AmetysRepositoryException {
        ArrayList<OrgUnitZone> zones = new ArrayList<OrgUnitZone>();
        zones.add(new OrgUnitZone(this, this._zoneDataTypeExtensionPoint, this._zoneItemDataTypeExtensionPoint));
        return new CollectionIterable(zones);
    }

    public boolean hasZone(String name) throws AmetysRepositoryException {
        return "default".equals(name);
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages() throws AmetysRepositoryException {
        ArrayList<OrgUnitPage> children = new ArrayList<OrgUnitPage>();
        for (Content content : this._organisationChartPageHandler.getChildContents(this._syncContent)) {
            children.add(new OrgUnitPage(this._root, content, this._path + "/" + content.getName(), this._resolver, this._organisationChartPageHandler, this._syncContentsCollectionDAO, this._skinsManager, this._pageDataTypeExtensionPoint, this._zoneDataTypeExtensionPoint, this._zoneItemDataTypeExtensionPoint));
        }
        return new CollectionIterable(children);
    }

    public String getPathInSitemap() throws AmetysRepositoryException {
        return this._root.getPathInSitemap() + "/" + this._path;
    }

    public Site getSite() throws AmetysRepositoryException {
        return this._root.getSite();
    }

    public String getSiteName() throws AmetysRepositoryException {
        return this._root.getSiteName();
    }

    public Sitemap getSitemap() throws AmetysRepositoryException {
        return this._root.getSitemap();
    }

    public String getSitemapName() throws AmetysRepositoryException {
        return this._root.getSitemapName();
    }

    public <A extends AmetysObject> A getChild(String path) throws AmetysRepositoryException, UnknownAmetysObjectException {
        if (path.isEmpty()) {
            throw new AmetysRepositoryException("path must be non empty");
        }
        Content childContent = this._organisationChartPageHandler.getChildFromPath(this._syncContent, path);
        if (childContent != null) {
            OrgUnitPage page = new OrgUnitPage(this._root, childContent, this._path + "/" + path, this._resolver, this._organisationChartPageHandler, this._syncContentsCollectionDAO, this._skinsManager, this._pageDataTypeExtensionPoint, this._zoneDataTypeExtensionPoint, this._zoneItemDataTypeExtensionPoint);
            return (A)page;
        }
        return null;
    }

    public AmetysObjectIterable<? extends AmetysObject> getChildren() throws AmetysRepositoryException {
        return this.getChildrenPages();
    }

    public boolean hasChild(String name) throws AmetysRepositoryException {
        return !this._organisationChartPageHandler.getChildContents(this._syncContent).stream().filter(c -> c.getName().equals(name)).collect(Collectors.toList()).isEmpty();
    }

    public String getId() throws AmetysRepositoryException {
        return "udorgunit://" + this._path + "?rootId=" + this._root.getId() + "&contentId=" + this._syncContent.getId();
    }

    public String getName() throws AmetysRepositoryException {
        return this._syncContent.getName();
    }

    public Page getParent() throws AmetysRepositoryException {
        Content parentContent = this._organisationChartPageHandler.getParentContent(this._syncContent);
        if (parentContent != null) {
            return new OrgUnitPage(this._root, parentContent, StringUtils.substringBeforeLast((String)this._path, (String)"/"), this._resolver, this._organisationChartPageHandler, this._syncContentsCollectionDAO, this._skinsManager, this._pageDataTypeExtensionPoint, this._zoneDataTypeExtensionPoint, this._zoneItemDataTypeExtensionPoint);
        }
        return this._root;
    }

    public String getParentPath() throws AmetysRepositoryException {
        if (this._path.contains("/")) {
            return this._root.getPath() + "/" + StringUtils.substringBeforeLast((String)this._path, (String)"/");
        }
        return this._root.getPath();
    }

    public String getPath() throws AmetysRepositoryException {
        return this._root.getPath() + "/" + this._path;
    }

    public ModelLessDataHolder getDataHolder() {
        MemoryRepositoryData repositoryData = new MemoryRepositoryData(this.getName());
        return new DefaultModelLessDataHolder((ModelItemTypeExtensionPoint)this._pageDataTypeExtensionPoint, (RepositoryData)repositoryData);
    }

    public Set<String> getTags() throws AmetysRepositoryException {
        return Collections.emptySet();
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages(boolean includeInvisiblePage) throws AmetysRepositoryException {
        return this.getChildrenPages();
    }

    public boolean isVisible() throws AmetysRepositoryException {
        return true;
    }

    public Page getChildPageAt(int index) throws UnknownAmetysObjectException, AmetysRepositoryException {
        throw new UnknownAmetysObjectException("There is no child for orgUnit page");
    }

    public ModelAwareDataHolder getTemplateParametersHolder() throws AmetysRepositoryException {
        return null;
    }
}

