/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.MemoryRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.userdirectory.UserDirectoryPageHandler;
import org.ametys.plugins.userdirectory.page.TransitionalZone;
import org.ametys.plugins.userdirectory.page.UserPage;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.UnknownZoneException;
import org.ametys.web.repository.page.Zone;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.service.ServiceExtensionPoint;
import org.ametys.web.skin.SkinsManager;
import org.apache.commons.lang.StringUtils;

public class TransitionalPage
implements Page {
    private Page _root;
    private String _path;
    private int _initialDepth;
    private String _prefix;
    private AmetysObjectResolver _resolver;
    private UserDirectoryPageHandler _userDirectoryPageHandler;
    private SynchronizableContentsCollectionDAO _syncContentsCollectionDAO;
    private SkinsManager _skinsManager;
    private SynchronizableContentsCollectionHelper _sccHelper;
    private org.ametys.web.data.type.ModelItemTypeExtensionPoint _pageDataTypeExtensionPoint;
    private org.ametys.web.data.type.ModelItemTypeExtensionPoint _zoneDataTypeExtensionPoint;
    private ServiceExtensionPoint _serviceExtensionPoint;
    private org.ametys.web.data.type.ModelItemTypeExtensionPoint _zoneItemDataTypeExtensionPoint;

    public TransitionalPage(Page root, String prefix, String path, AmetysObjectResolver resolver, UserDirectoryPageHandler userDirectoryPageHandler, SynchronizableContentsCollectionDAO syncContentsCollectionDAO, SkinsManager skinsManager, SynchronizableContentsCollectionHelper sccHelper, org.ametys.web.data.type.ModelItemTypeExtensionPoint pageDataTypeExtensionPoint, org.ametys.web.data.type.ModelItemTypeExtensionPoint zoneDataTypeExtensionPoint, ServiceExtensionPoint serviceExtensionPoint, org.ametys.web.data.type.ModelItemTypeExtensionPoint zoneItemDataTypeExtensionPoint) {
        this._root = root;
        this._prefix = prefix;
        this._path = path;
        this._resolver = resolver;
        this._userDirectoryPageHandler = userDirectoryPageHandler;
        this._syncContentsCollectionDAO = syncContentsCollectionDAO;
        this._skinsManager = skinsManager;
        this._sccHelper = sccHelper;
        this._initialDepth = this._userDirectoryPageHandler.getDepth(this._root);
        this._pageDataTypeExtensionPoint = pageDataTypeExtensionPoint;
        this._zoneDataTypeExtensionPoint = zoneDataTypeExtensionPoint;
        this._serviceExtensionPoint = serviceExtensionPoint;
        this._zoneItemDataTypeExtensionPoint = zoneItemDataTypeExtensionPoint;
    }

    public int getDepth() throws AmetysRepositoryException {
        return this._root.getDepth() + this._path.split("/").length;
    }

    public Set<String> getReferers() throws AmetysRepositoryException {
        return null;
    }

    public ResourceCollection getRootAttachments() throws AmetysRepositoryException {
        return null;
    }

    public String getTemplate() throws AmetysRepositoryException {
        return "page";
    }

    public String getTitle() throws AmetysRepositoryException {
        return StringUtils.upperCase((String)this._prefix);
    }

    public String getLongTitle() throws AmetysRepositoryException {
        return StringUtils.upperCase((String)this._prefix);
    }

    public Page.PageType getType() throws AmetysRepositoryException {
        return Page.PageType.CONTAINER;
    }

    public String getURL() throws AmetysRepositoryException {
        throw new UnsupportedOperationException("getURL not supported on virtual user directory pages");
    }

    public Page.LinkType getURLType() throws AmetysRepositoryException {
        throw new UnsupportedOperationException("getURLType not supported on virtual user directory pages");
    }

    public Zone getZone(String name) throws UnknownZoneException, AmetysRepositoryException {
        if (!"default".equals(name)) {
            throw new IllegalArgumentException("Only the zone named 'default' is actually supported on virtual transitional pages.");
        }
        return new TransitionalZone(this, this._zoneDataTypeExtensionPoint, this._serviceExtensionPoint, this._zoneItemDataTypeExtensionPoint);
    }

    public AmetysObjectIterable<? extends Zone> getZones() throws AmetysRepositoryException {
        ArrayList<TransitionalZone> zones = new ArrayList<TransitionalZone>();
        zones.add(new TransitionalZone(this, this._zoneDataTypeExtensionPoint, this._serviceExtensionPoint, this._zoneItemDataTypeExtensionPoint));
        return new CollectionIterable(zones);
    }

    public boolean hasZone(String name) throws AmetysRepositoryException {
        return "default".equals(name);
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages() throws AmetysRepositoryException {
        ArrayList<Object> children = new ArrayList<Object>();
        int depth = this._initialDepth - this._path.split("/").length;
        if (depth > 0) {
            SortedSet<String> transitionalPagesName = this._userDirectoryPageHandler.getTransitionalPagesName(this._root, this._userDirectoryPageHandler.getName(this._path));
            for (String string : transitionalPagesName) {
                String string2 = this._userDirectoryPageHandler.getPathName(string);
                children.add(new TransitionalPage(this._root, string, this._path + "/" + string2, this._resolver, this._userDirectoryPageHandler, this._syncContentsCollectionDAO, this._skinsManager, this._sccHelper, this._pageDataTypeExtensionPoint, this._zoneDataTypeExtensionPoint, this._serviceExtensionPoint, this._zoneItemDataTypeExtensionPoint));
            }
            Map<String, String> userPagesContent = this._userDirectoryPageHandler.getUserPagesContent(this._root, this._userDirectoryPageHandler.getName(this._path));
            for (Map.Entry<String, String> entry : userPagesContent.entrySet()) {
                Content content;
                String contentTypeId = this._userDirectoryPageHandler.getContentTypeId(this._root);
                String classificationAttribute = this._userDirectoryPageHandler.getClassificationAttribute(this._root);
                try {
                    content = (Content)this._resolver.resolveById(entry.getValue());
                }
                catch (AmetysRepositoryException e) {
                    break;
                }
                if (content != null && Arrays.asList(content.getTypes()).contains(contentTypeId) && content.hasValue(classificationAttribute)) {
                    String classificationAttributeValue = this._userDirectoryPageHandler.getTransformedClassificationValue(this._root, content);
                    if (classificationAttributeValue == null || classificationAttributeValue.length() != this._path.split("/").length) continue;
                    children.add(new UserPage(this._root, content, this._path, this._resolver, this._userDirectoryPageHandler, this._syncContentsCollectionDAO, this._skinsManager, this._sccHelper, this._pageDataTypeExtensionPoint, this._zoneDataTypeExtensionPoint, this._serviceExtensionPoint, this._zoneItemDataTypeExtensionPoint));
                    continue;
                }
                break;
            }
        } else {
            Map<String, String> userPagesContent = this._userDirectoryPageHandler.getUserPagesContent(this._root, this._path);
            for (String string : userPagesContent.values()) {
                try {
                    Content content = (Content)this._resolver.resolveById(string);
                    children.add(new UserPage(this._root, content, this._path, this._resolver, this._userDirectoryPageHandler, this._syncContentsCollectionDAO, this._skinsManager, this._sccHelper, this._pageDataTypeExtensionPoint, this._zoneDataTypeExtensionPoint, this._serviceExtensionPoint, this._zoneItemDataTypeExtensionPoint));
                }
                catch (UnknownAmetysObjectException unknownAmetysObjectException) {
                    System.out.println("Content does not exist anymore");
                }
            }
        }
        return new CollectionIterable(children);
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages(boolean includeInvisiblePage) throws AmetysRepositoryException {
        if (includeInvisiblePage) {
            return this.getChildrenPages();
        }
        ArrayList children = new ArrayList();
        return new CollectionIterable(children);
    }

    public String getPathInSitemap() throws AmetysRepositoryException {
        String path = StringUtils.lowerCase((String)this._path);
        return this._root.getPathInSitemap() + "/" + path;
    }

    public Site getSite() throws AmetysRepositoryException {
        return this._root.getSite();
    }

    public String getSiteName() throws AmetysRepositoryException {
        return this._root.getSiteName();
    }

    public Sitemap getSitemap() throws AmetysRepositoryException {
        return this._root.getSitemap();
    }

    public String getSitemapName() throws AmetysRepositoryException {
        return this._root.getSitemapName();
    }

    public <A extends AmetysObject> A getChild(String path) throws AmetysRepositoryException, UnknownAmetysObjectException {
        if (path.isEmpty()) {
            throw new AmetysRepositoryException("path must be non empty");
        }
        String completePath = this._path + "/" + path;
        int depth = this._initialDepth - completePath.split("/").length + 1;
        if (depth > 0) {
            String namePath = StringUtils.substringAfterLast((String)completePath, (String)"/");
            String parentPath = StringUtils.substringBeforeLast((String)completePath, (String)"/");
            SortedSet<String> transitionalPagesName = this._userDirectoryPageHandler.getTransitionalPagesName(this._root, parentPath);
            Map<String, String> userPagesContent = this._userDirectoryPageHandler.getUserPagesContent(this._root, parentPath);
            String name = this._userDirectoryPageHandler.getName(namePath);
            if (transitionalPagesName.contains(name)) {
                TransitionalPage page = new TransitionalPage(this._root, name, completePath, this._resolver, this._userDirectoryPageHandler, this._syncContentsCollectionDAO, this._skinsManager, this._sccHelper, this._pageDataTypeExtensionPoint, this._zoneDataTypeExtensionPoint, this._serviceExtensionPoint, this._zoneItemDataTypeExtensionPoint);
                return (A)page;
            }
            if (userPagesContent.containsKey(name)) {
                String contentId = userPagesContent.get(name);
                Content syncContent = (Content)this._resolver.resolveById(contentId);
                UserPage page = new UserPage(this._root, syncContent, parentPath, this._resolver, this._userDirectoryPageHandler, this._syncContentsCollectionDAO, this._skinsManager, this._sccHelper, this._pageDataTypeExtensionPoint, this._zoneDataTypeExtensionPoint, this._serviceExtensionPoint, this._zoneItemDataTypeExtensionPoint);
                return (A)page;
            }
            throw new UnknownAmetysObjectException("No transitional page named " + name + " (full page path " + path + ").");
        }
        String userPath = StringUtils.substringBeforeLast((String)completePath, (String)"/");
        String contentName = StringUtils.substringAfterLast((String)completePath, (String)"/");
        Map<String, String> userPagesContent = this._userDirectoryPageHandler.getUserPagesContent(this._root, userPath);
        if (userPagesContent.containsKey(contentName)) {
            Content content = (Content)this._resolver.resolveById(userPagesContent.get(contentName));
            UserPage page = new UserPage(this._root, content, userPath, this._resolver, this._userDirectoryPageHandler, this._syncContentsCollectionDAO, this._skinsManager, this._sccHelper, this._pageDataTypeExtensionPoint, this._zoneDataTypeExtensionPoint, this._serviceExtensionPoint, this._zoneItemDataTypeExtensionPoint);
            return (A)page;
        }
        throw new UnknownAmetysObjectException("No user content named " + contentName + " (full page path " + path + ").");
    }

    public AmetysObjectIterable<? extends AmetysObject> getChildren() throws AmetysRepositoryException {
        return this.getChildrenPages();
    }

    public boolean hasChild(String name) throws AmetysRepositoryException {
        int depth = this._initialDepth - this._path.split("/").length;
        if (depth > 0) {
            SortedSet<String> transitionalPagesName = this._userDirectoryPageHandler.getTransitionalPagesName(this._root, this._path);
            Map<String, String> userPagesContent = this._userDirectoryPageHandler.getUserPagesContent(this._root, this._path);
            return transitionalPagesName.contains(name) || userPagesContent.containsKey(name);
        }
        Map<String, String> userPagesContent = this._userDirectoryPageHandler.getUserPagesContent(this._root, this._path);
        return userPagesContent.containsKey(name);
    }

    public String getId() throws AmetysRepositoryException {
        return "udtransitional://" + this._path + "?rootId=" + this._root.getId();
    }

    public String getName() throws AmetysRepositoryException {
        return StringUtils.lowerCase((String)this._prefix);
    }

    public Page getParent() throws AmetysRepositoryException {
        if (this._path.split("/").length > 1) {
            String parentPath = StringUtils.substringBeforeLast((String)this._path, (String)"/");
            String pathName = parentPath;
            if (StringUtils.contains((String)pathName, (String)"/")) {
                pathName = StringUtils.substringAfterLast((String)pathName, (String)"/");
            }
            String name = this._userDirectoryPageHandler.getName(pathName);
            return new TransitionalPage(this._root, name, parentPath, this._resolver, this._userDirectoryPageHandler, this._syncContentsCollectionDAO, this._skinsManager, this._sccHelper, this._pageDataTypeExtensionPoint, this._zoneDataTypeExtensionPoint, this._serviceExtensionPoint, this._zoneItemDataTypeExtensionPoint);
        }
        return this._root;
    }

    public String getParentPath() throws AmetysRepositoryException {
        if (this._path.split("/").length > 1) {
            String path = StringUtils.lowerCase((String)this._path);
            return this._root.getPath() + "/" + StringUtils.substringBeforeLast((String)path, (String)"/");
        }
        return this._root.getPath();
    }

    public String getPath() throws AmetysRepositoryException {
        return this.getParentPath() + "/" + this.getName();
    }

    public ModelLessDataHolder getDataHolder() {
        MemoryRepositoryData repositoryData = new MemoryRepositoryData(this.getName());
        return new DefaultModelLessDataHolder((ModelItemTypeExtensionPoint)this._pageDataTypeExtensionPoint, (RepositoryData)repositoryData);
    }

    public Set<String> getTags() throws AmetysRepositoryException {
        return Collections.emptySet();
    }

    public boolean isVisible() throws AmetysRepositoryException {
        return false;
    }

    public Page getChildPageAt(int index) throws UnknownAmetysObjectException, AmetysRepositoryException {
        return (Page)this.getChildrenPages().stream().collect(Collectors.toList()).get(index);
    }

    public ModelAwareDataHolder getTemplateParametersHolder() throws AmetysRepositoryException {
        return null;
    }
}

