/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.page;

import java.util.SortedSet;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.userdirectory.UserDirectoryPageHandler;
import org.ametys.plugins.userdirectory.page.TransitionalPage;
import org.ametys.web.data.type.ModelItemTypeExtensionPoint;
import org.ametys.web.repository.page.Page;
import org.ametys.web.service.ServiceExtensionPoint;
import org.ametys.web.skin.SkinsManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang.StringUtils;

public class TransitionalPageFactory
implements AmetysObjectFactory<TransitionalPage>,
Serviceable {
    private AmetysObjectResolver _resolver;
    private UserDirectoryPageHandler _userDirectoryPageHandler;
    private SynchronizableContentsCollectionDAO _synchronizableContentsCollectionDAO;
    private SkinsManager _skinManager;
    private SynchronizableContentsCollectionHelper _sccHelper;
    private ServiceExtensionPoint _serviceExtensionPoint;
    private ModelItemTypeExtensionPoint _pageDataTypeExtensionPoint;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._userDirectoryPageHandler = (UserDirectoryPageHandler)((Object)manager.lookup(UserDirectoryPageHandler.ROLE));
        this._synchronizableContentsCollectionDAO = (SynchronizableContentsCollectionDAO)manager.lookup(SynchronizableContentsCollectionDAO.ROLE);
        this._skinManager = (SkinsManager)manager.lookup(SkinsManager.ROLE);
        this._sccHelper = (SynchronizableContentsCollectionHelper)manager.lookup(SynchronizableContentsCollectionHelper.ROLE);
        this._pageDataTypeExtensionPoint = (ModelItemTypeExtensionPoint)manager.lookup(ModelItemTypeExtensionPoint.ROLE_PAGE_DATA);
        this._serviceExtensionPoint = (ServiceExtensionPoint)manager.lookup(ServiceExtensionPoint.ROLE);
    }

    public TransitionalPage getAmetysObjectById(String id) throws AmetysRepositoryException {
        String path = StringUtils.substringBefore((String)StringUtils.substringAfter((String)id, (String)"udtransitional://"), (String)"?rootId=");
        String rootId = StringUtils.substringAfter((String)id, (String)"?rootId=");
        Page root = (Page)this._resolver.resolveById(rootId);
        String pathName = path;
        String parentPath = "_root";
        if (StringUtils.contains((String)path, (String)"/")) {
            pathName = StringUtils.substringAfterLast((String)path, (String)"/");
            parentPath = StringUtils.substringBeforeLast((String)path, (String)"/");
        }
        String name = this._userDirectoryPageHandler.getName(pathName);
        SortedSet<String> transitionalPagesName = this._userDirectoryPageHandler.getTransitionalPagesName(root, this._userDirectoryPageHandler.getName(parentPath));
        if (transitionalPagesName.contains(name)) {
            return new TransitionalPage(root, name, path, this._resolver, this._userDirectoryPageHandler, this._synchronizableContentsCollectionDAO, this._skinManager, this._sccHelper, this._pageDataTypeExtensionPoint, this._pageDataTypeExtensionPoint, this._serviceExtensionPoint, this._pageDataTypeExtensionPoint);
        }
        throw new UnknownAmetysObjectException("No transitional page named " + name + " (full page path " + path + ").");
    }

    public boolean hasAmetysObjectForId(String id) throws AmetysRepositoryException {
        try {
            String path = StringUtils.substringBefore((String)StringUtils.substringAfter((String)id, (String)"udtransitional://"), (String)"?rootId=");
            String rootId = StringUtils.substringAfter((String)id, (String)"?rootId=");
            Page root = (Page)this._resolver.resolveById(rootId);
            String pathName = path;
            String parentPath = "_root";
            if (StringUtils.contains((String)path, (String)"/")) {
                pathName = StringUtils.substringAfterLast((String)path, (String)"/");
                parentPath = StringUtils.substringBeforeLast((String)path, (String)"/");
            }
            String name = this._userDirectoryPageHandler.getName(pathName);
            SortedSet<String> transitionalPagesName = this._userDirectoryPageHandler.getTransitionalPagesName(root, this._userDirectoryPageHandler.getName(parentPath));
            return transitionalPagesName.contains(name);
        }
        catch (UnknownAmetysObjectException e) {
            return false;
        }
    }

    public String getScheme() {
        return "udtransitional";
    }
}

