/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.page;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.ametys.cms.languages.LanguagesManager;
import org.ametys.cms.repository.Content;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.plugins.userdirectory.UserDirectoryPageHandler;
import org.ametys.plugins.userdirectory.page.UserPage;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang.StringUtils;

public class UserDirectoryPageResolver
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable,
Contextualizable {
    public static final String ROLE = UserDirectoryPageResolver.class.getName();
    protected static final String _CACHE_KEY_EMPTY_SITE = "_ametys_no_site";
    protected AmetysObjectResolver _ametysResolver;
    protected UserDirectoryPageHandler _pageHandler;
    protected AbstractCacheManager _cacheManager;
    protected Context _context;
    protected LanguagesManager _languagesManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._ametysResolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._pageHandler = (UserDirectoryPageHandler)((Object)serviceManager.lookup(UserDirectoryPageHandler.ROLE));
        this._cacheManager = (AbstractCacheManager)serviceManager.lookup(AbstractCacheManager.ROLE);
        this._languagesManager = (LanguagesManager)serviceManager.lookup(LanguagesManager.ROLE);
    }

    public void initialize() throws Exception {
        this._cacheManager.createMemoryCache(ROLE, new I18nizableText("plugin.user-directory", "PLUGINS_USER_DIRECTORY_USER_PAGE_CACHE_LABEL"), new I18nizableText("plugin.user-directory", "PLUGINS_USER_DIRECTORY_USER_PAGE_CACHE_DESCRIPTION"), true, null);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public UserPage getUserPage(Content userContent, String siteName, String sitemapName) {
        for (String contentTypeId : userContent.getTypes()) {
            UserPage userPage = this.getUserPage(userContent, siteName, sitemapName, contentTypeId);
            if (userPage == null) continue;
            return userPage;
        }
        return null;
    }

    public UserPage getUserPage(Content userContent, String siteName, String sitemapName, String contentTypeId) {
        String siteKey = StringUtils.isNotBlank((String)siteName) ? siteName : _CACHE_KEY_EMPTY_SITE;
        String pageId = null;
        String contentLang = userContent.getLanguage();
        if (StringUtils.isNotBlank((String)contentLang)) {
            UserPageElementKey key = UserPageElementKey.of(contentLang, userContent.getId(), siteKey, contentTypeId);
            pageId = (String)this._getCache().get((Object)key, k -> this._getUserPageId(userContent, siteName, contentLang, contentTypeId));
        } else {
            Iterator<String> languageIterator = this._getLanguagesToTest(sitemapName).iterator();
            while (pageId == null && languageIterator.hasNext()) {
                String lang = languageIterator.next();
                UserPageElementKey key = UserPageElementKey.of(lang, userContent.getId(), siteKey, contentTypeId);
                pageId = (String)this._getCache().get((Object)key, k -> this._getUserPageId(userContent, siteName, lang, contentTypeId));
            }
        }
        return this._getUserPage(pageId);
    }

    private Set<String> _getLanguagesToTest(String givenLang) {
        HashSet<String> languages = new HashSet<String>();
        if (StringUtils.isNotBlank((String)givenLang)) {
            languages.add(givenLang);
        }
        languages.add("en");
        languages.addAll(this._languagesManager.getAvailableLanguages().keySet());
        return languages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String _getUserPageId(Content userContent, String siteName, String language, String contentTypeId) {
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            Page userDirectoryRootPage = this._pageHandler.getUserDirectoryRootPage(siteName, language, contentTypeId);
            if (userDirectoryRootPage == null) {
                String string = null;
                return string;
            }
            String string = this.getUserPageId(userDirectoryRootPage, userContent);
            return string;
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }

    public UserPage getUserPage(Page userDirectoryRootPage, Content userContent) {
        String pageId = this.getUserPageId(userDirectoryRootPage, userContent);
        return this._getUserPage(pageId);
    }

    public String getUserPageId(Page userDirectoryRootPage, Content userContent) {
        String userPath = this._getUserPath(userDirectoryRootPage, userContent);
        if (userPath != null) {
            return UserPage.getId(userPath, userDirectoryRootPage.getId(), userContent.getId());
        }
        return null;
    }

    private String _getUserPath(Page userDirectoryRootPage, Content userContent) {
        String value = this._pageHandler.getTransformedClassificationValue(userDirectoryRootPage, userContent);
        return value != null ? value.replaceAll("(.)(?!$)", "$1/") : null;
    }

    private UserPage _getUserPage(String pageId) {
        try {
            return pageId != null ? (UserPage)this._ametysResolver.resolveById(pageId) : null;
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
    }

    private Cache<UserPageElementKey, String> _getCache() {
        return this._cacheManager.get(ROLE);
    }

    public void invalidateUserPageCache(String lang) {
        if (StringUtils.isNotBlank((String)lang)) {
            this._getCache().invalidate((Object)UserPageElementKey.of(lang));
        } else {
            this._getCache().invalidateAll();
        }
    }

    static class UserPageElementKey
    extends AbstractCacheKey {
        UserPageElementKey(String lang, String contentId, String siteName, String contentTypeId) {
            super(new Object[]{lang, contentId, siteName, contentTypeId});
        }

        static UserPageElementKey of(String lang, String contentId, String siteName, String contentTypeId) {
            return new UserPageElementKey(lang, contentId, siteName, contentTypeId);
        }

        static UserPageElementKey of(String lang) {
            return new UserPageElementKey(lang, null, null, null);
        }
    }
}

