/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.ProfileAssignmentStorage;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.ACLAmetysObject;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.ModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.MemoryRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.userdirectory.UserDirectoryPageHandler;
import org.ametys.plugins.userdirectory.page.TransitionalPage;
import org.ametys.plugins.userdirectory.page.UserZone;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.UnknownZoneException;
import org.ametys.web.repository.page.Zone;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.service.ServiceExtensionPoint;
import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinsManager;
import org.apache.commons.lang.StringUtils;

public class UserPage
implements Page,
ACLAmetysObject {
    private static final String __USER_PAGE_TEMPLATE = "user-page";
    private Page _root;
    private int _initialDepth;
    private String _title;
    private AmetysObjectResolver _resolver;
    private UserDirectoryPageHandler _userDirectoryPageHandler;
    private SynchronizableContentsCollectionDAO _syncContentsCollectionDAO;
    private SkinsManager _skinsManager;
    private String _path;
    private Content _syncContent;
    private SynchronizableContentsCollectionHelper _sccHelper;
    private org.ametys.web.data.type.ModelItemTypeExtensionPoint _pageDataTypeExtensionPoint;
    private org.ametys.web.data.type.ModelItemTypeExtensionPoint _zoneDataTypeExtensionPoint;
    private ServiceExtensionPoint _serviceExtensionPoint;
    private org.ametys.web.data.type.ModelItemTypeExtensionPoint _zoneItemDataTypeExtensionPoint;

    public UserPage(Page root, Content syncContent, String path, AmetysObjectResolver resolver, UserDirectoryPageHandler userDirectoryPageHandler, SynchronizableContentsCollectionDAO syncContentsCollectionDAO, SkinsManager skinsManager, SynchronizableContentsCollectionHelper sccHelper, org.ametys.web.data.type.ModelItemTypeExtensionPoint pageDataTypeExtensionPoint, org.ametys.web.data.type.ModelItemTypeExtensionPoint zoneDataTypeExtensionPoint, ServiceExtensionPoint serviceExtensionPoint, org.ametys.web.data.type.ModelItemTypeExtensionPoint zoneItemDataTypeExtensionPoint) {
        this._root = root;
        this._path = path;
        this._resolver = resolver;
        this._userDirectoryPageHandler = userDirectoryPageHandler;
        this._syncContentsCollectionDAO = syncContentsCollectionDAO;
        this._skinsManager = skinsManager;
        this._syncContent = syncContent;
        this._sccHelper = sccHelper;
        this._title = this._syncContent.getTitle(new Locale(root.getSitemapName()));
        this._initialDepth = this._userDirectoryPageHandler.getDepth(this._root);
        this._pageDataTypeExtensionPoint = pageDataTypeExtensionPoint;
        this._zoneDataTypeExtensionPoint = zoneDataTypeExtensionPoint;
        this._serviceExtensionPoint = serviceExtensionPoint;
        this._zoneItemDataTypeExtensionPoint = zoneItemDataTypeExtensionPoint;
    }

    public static String getId(String path, String rootId, String contentId) {
        return "uduser://" + (StringUtils.isEmpty((String)path) ? "_root" : path) + "?rootId=" + rootId + "&contentId=" + contentId;
    }

    public Content getSyncContent() {
        return this._syncContent;
    }

    public int getDepth() throws AmetysRepositoryException {
        return this._root.getDepth() + this._initialDepth + 1;
    }

    public Set<String> getReferers() throws AmetysRepositoryException {
        return null;
    }

    public ResourceCollection getRootAttachments() throws AmetysRepositoryException {
        return null;
    }

    public String getTemplate() throws AmetysRepositoryException {
        Skin skin = this._skinsManager.getSkin(this.getSite().getSkinId());
        if (skin.getTemplate(__USER_PAGE_TEMPLATE) != null) {
            return __USER_PAGE_TEMPLATE;
        }
        return "page";
    }

    public String getTitle() throws AmetysRepositoryException {
        return this._title;
    }

    public String getLongTitle() throws AmetysRepositoryException {
        return this._title;
    }

    public Page.PageType getType() throws AmetysRepositoryException {
        return Page.PageType.CONTAINER;
    }

    public String getURL() throws AmetysRepositoryException {
        throw new UnsupportedOperationException("#getURL is not supported on virtual user pages");
    }

    public Page.LinkType getURLType() throws AmetysRepositoryException {
        throw new UnsupportedOperationException("#getURLType is not supported on virtual user pages");
    }

    public Zone getZone(String name) throws UnknownZoneException, AmetysRepositoryException {
        if (!"default".equals(name)) {
            throw new IllegalArgumentException("Only the zone named 'default' is actually supported on virtual user pages.");
        }
        return new UserZone(this, this._zoneDataTypeExtensionPoint, this._zoneItemDataTypeExtensionPoint);
    }

    public AmetysObjectIterable<? extends Zone> getZones() throws AmetysRepositoryException {
        ArrayList<UserZone> zones = new ArrayList<UserZone>();
        zones.add(new UserZone(this, this._zoneDataTypeExtensionPoint, this._zoneItemDataTypeExtensionPoint));
        return new CollectionIterable(zones);
    }

    public boolean hasZone(String name) throws AmetysRepositoryException {
        return "default".equals(name);
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages() throws AmetysRepositoryException {
        ArrayList children = new ArrayList();
        return new CollectionIterable(children);
    }

    public String getPathInSitemap() throws AmetysRepositoryException {
        if (this._path.equals("_root")) {
            return this._root.getPathInSitemap() + "/" + this.getName();
        }
        String path = StringUtils.lowerCase((String)this._path);
        return this._root.getPathInSitemap() + "/" + path + "/" + this.getName();
    }

    public Site getSite() throws AmetysRepositoryException {
        return this._root.getSite();
    }

    public String getSiteName() throws AmetysRepositoryException {
        return this._root.getSiteName();
    }

    public Sitemap getSitemap() throws AmetysRepositoryException {
        return this._root.getSitemap();
    }

    public String getSitemapName() throws AmetysRepositoryException {
        return this._root.getSitemapName();
    }

    public <A extends AmetysObject> A getChild(String path) throws AmetysRepositoryException, UnknownAmetysObjectException {
        if (path.isEmpty()) {
            throw new AmetysRepositoryException("path must be non empty");
        }
        return null;
    }

    public AmetysObjectIterable<? extends AmetysObject> getChildren() throws AmetysRepositoryException {
        return this.getChildrenPages();
    }

    public boolean hasChild(String name) throws AmetysRepositoryException {
        return false;
    }

    public String getId() throws AmetysRepositoryException {
        return UserPage.getId(this._path, this._root.getId(), this._syncContent.getId());
    }

    public String getName() throws AmetysRepositoryException {
        return this._syncContent.getName();
    }

    public Page getParent() throws AmetysRepositoryException {
        if (this._initialDepth > 0) {
            String pathName = StringUtils.substringAfterLast((String)this._path, (String)"/");
            String name = this._userDirectoryPageHandler.getName(pathName);
            return new TransitionalPage(this._root, name, this._path, this._resolver, this._userDirectoryPageHandler, this._syncContentsCollectionDAO, this._skinsManager, this._sccHelper, this._pageDataTypeExtensionPoint, this._zoneDataTypeExtensionPoint, this._serviceExtensionPoint, this._zoneItemDataTypeExtensionPoint);
        }
        return this._root;
    }

    public String getParentPath() throws AmetysRepositoryException {
        if (this._initialDepth > 0) {
            String path = StringUtils.lowerCase((String)this._path);
            return this._root.getPath() + "/" + path;
        }
        return this._root.getPath();
    }

    public String getPath() throws AmetysRepositoryException {
        return this.getParentPath() + "/" + this.getName();
    }

    public ModelLessDataHolder getDataHolder() {
        MemoryRepositoryData repositoryData = new MemoryRepositoryData(this.getName());
        return new DefaultModelLessDataHolder((ModelItemTypeExtensionPoint)this._pageDataTypeExtensionPoint, (RepositoryData)repositoryData);
    }

    public Set<String> getTags() throws AmetysRepositoryException {
        return Collections.emptySet();
    }

    public AmetysObjectIterable<? extends Page> getChildrenPages(boolean includeInvisiblePage) throws AmetysRepositoryException {
        ArrayList children = new ArrayList();
        return new CollectionIterable(children);
    }

    public boolean isVisible() throws AmetysRepositoryException {
        return false;
    }

    public Page getChildPageAt(int index) throws UnknownAmetysObjectException, AmetysRepositoryException {
        throw new UnknownAmetysObjectException("There is no child for user page");
    }

    public Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> getProfilesForAnonymousAndAnyConnectedUser() {
        Set collectionIds = this._sccHelper.getSynchronizableCollectionIds(this._syncContent);
        for (String collectionId : collectionIds) {
            Boolean restricted;
            String restrictedField;
            SynchronizableContentsCollection collection = this._syncContentsCollectionDAO.getSynchronizableContentsCollection(collectionId);
            if (collection == null || StringUtils.isEmpty((String)(restrictedField = collection.getRestrictedField())) || (restricted = (Boolean)this._syncContent.getValue(restrictedField)) == null || !restricted.booleanValue()) continue;
            return Map.of(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED, Set.of("READER"));
        }
        return Map.of();
    }

    public Map<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> getProfilesForGroups(Set<GroupIdentity> groups) {
        return Map.of();
    }

    public Map<UserIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> getProfilesForUsers(UserIdentity user) {
        return Map.of();
    }

    public boolean isInheritanceDisallowed() {
        return false;
    }

    public ModelAwareDataHolder getTemplateParametersHolder() throws AmetysRepositoryException {
        return null;
    }
}

