/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.page;

import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.userdirectory.UserDirectoryPageHandler;
import org.ametys.plugins.userdirectory.page.UserPage;
import org.ametys.web.data.type.ModelItemTypeExtensionPoint;
import org.ametys.web.repository.page.Page;
import org.ametys.web.service.ServiceExtensionPoint;
import org.ametys.web.skin.SkinsManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang.StringUtils;

public class UserPageFactory
implements AmetysObjectFactory<UserPage>,
Serviceable {
    private AmetysObjectResolver _resolver;
    private UserDirectoryPageHandler _userDirectoryPageHandler;
    private SynchronizableContentsCollectionDAO _synchronizableContentsCollectionDAO;
    private SkinsManager _skinManager;
    private SynchronizableContentsCollectionHelper _sccHelper;
    private ServiceExtensionPoint _serviceExtensionPoint;
    private ModelItemTypeExtensionPoint _pageDataTypeExtensionPoint;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._userDirectoryPageHandler = (UserDirectoryPageHandler)((Object)manager.lookup(UserDirectoryPageHandler.ROLE));
        this._synchronizableContentsCollectionDAO = (SynchronizableContentsCollectionDAO)manager.lookup(SynchronizableContentsCollectionDAO.ROLE);
        this._skinManager = (SkinsManager)manager.lookup(SkinsManager.ROLE);
        this._sccHelper = (SynchronizableContentsCollectionHelper)manager.lookup(SynchronizableContentsCollectionHelper.ROLE);
        this._pageDataTypeExtensionPoint = (ModelItemTypeExtensionPoint)manager.lookup(ModelItemTypeExtensionPoint.ROLE_PAGE_DATA);
        this._serviceExtensionPoint = (ServiceExtensionPoint)manager.lookup(ServiceExtensionPoint.ROLE);
    }

    public UserPage getAmetysObjectById(String id) throws AmetysRepositoryException {
        String path = StringUtils.substringBefore((String)StringUtils.substringAfter((String)id, (String)"uduser://"), (String)"?rootId=");
        String rootId = StringUtils.substringBefore((String)StringUtils.substringAfter((String)id, (String)"?rootId="), (String)"&contentId=");
        Page root = (Page)this._resolver.resolveById(rootId);
        String contentId = StringUtils.substringAfter((String)id, (String)"&contentId=");
        Map<String, String> userPagesContent = this._userDirectoryPageHandler.getUserPagesContent(root, path);
        if (userPagesContent.values().contains(contentId)) {
            Content syncContent = (Content)this._resolver.resolveById(contentId);
            return new UserPage(root, syncContent, path, this._resolver, this._userDirectoryPageHandler, this._synchronizableContentsCollectionDAO, this._skinManager, this._sccHelper, this._pageDataTypeExtensionPoint, this._pageDataTypeExtensionPoint, this._serviceExtensionPoint, this._pageDataTypeExtensionPoint);
        }
        throw new UnknownAmetysObjectException("No user content for id " + contentId);
    }

    public boolean hasAmetysObjectForId(String id) throws AmetysRepositoryException {
        String path = StringUtils.substringBefore((String)StringUtils.substringAfter((String)id, (String)"uduser://"), (String)"?rootId=");
        String rootId = StringUtils.substringBefore((String)StringUtils.substringAfter((String)id, (String)"?rootId="), (String)"&contentId=");
        if (!this._resolver.hasAmetysObjectForId(rootId)) {
            return false;
        }
        Page root = (Page)this._resolver.resolveById(rootId);
        String contentId = StringUtils.substringAfter((String)id, (String)"&contentId=");
        Map<String, String> userPagesContent = this._userDirectoryPageHandler.getUserPagesContent(root, path);
        return userPagesContent.values().contains(contentId);
    }

    public String getScheme() {
        return "uduser";
    }

    SynchronizableContentsCollectionDAO _getSynchronizableContentsCollectionDAO() {
        return this._synchronizableContentsCollectionDAO;
    }
}

