/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.page;

import java.util.ArrayList;
import java.util.Map;
import java.util.SortedSet;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.virtual.VirtualAmetysObjectFactory;
import org.ametys.plugins.userdirectory.UserDirectoryPageHandler;
import org.ametys.plugins.userdirectory.page.TransitionalPage;
import org.ametys.plugins.userdirectory.page.UserPage;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.data.type.ModelItemTypeExtensionPoint;
import org.ametys.web.repository.page.Page;
import org.ametys.web.service.ServiceExtensionPoint;
import org.ametys.web.skin.SkinsManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class VirtualUserDirectoryPageFactory
extends AbstractLogEnabled
implements VirtualAmetysObjectFactory<Page>,
Serviceable {
    protected UserDirectoryPageHandler _userDirectoryPageHandler;
    protected AmetysObjectResolver _resolver;
    private SynchronizableContentsCollectionDAO _synchronizableContentsCollectionDAO;
    private SkinsManager _skinManager;
    private SynchronizableContentsCollectionHelper _sccHelper;
    private ModelItemTypeExtensionPoint _pageDataTypeExtensionPoint;
    private ServiceExtensionPoint _serviceExtensionPoint;

    public void service(ServiceManager manager) throws ServiceException {
        this._userDirectoryPageHandler = (UserDirectoryPageHandler)((Object)manager.lookup(UserDirectoryPageHandler.ROLE));
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._synchronizableContentsCollectionDAO = (SynchronizableContentsCollectionDAO)manager.lookup(SynchronizableContentsCollectionDAO.ROLE);
        this._skinManager = (SkinsManager)manager.lookup(SkinsManager.ROLE);
        this._sccHelper = (SynchronizableContentsCollectionHelper)manager.lookup(SynchronizableContentsCollectionHelper.ROLE);
        this._pageDataTypeExtensionPoint = (ModelItemTypeExtensionPoint)manager.lookup(ModelItemTypeExtensionPoint.ROLE_PAGE_DATA);
        this._serviceExtensionPoint = (ServiceExtensionPoint)manager.lookup(ServiceExtensionPoint.ROLE);
    }

    public Page getAmetysObjectById(String id) throws AmetysRepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean hasAmetysObjectForId(String id) throws AmetysRepositoryException {
        throw new UnsupportedOperationException();
    }

    public String getScheme() {
        return "udroot";
    }

    public AmetysObjectIterable<Page> getChildren(JCRAmetysObject parent) {
        if (!(parent instanceof Page)) {
            throw new IllegalArgumentException("The holder of the user directory virtual pages should be a page.");
        }
        ArrayList<Object> children = new ArrayList<Object>();
        Page rootPage = (Page)parent;
        int depth = this._userDirectoryPageHandler.getDepth(rootPage);
        if (depth > 0) {
            SortedSet<String> transitionalPagesName = this._userDirectoryPageHandler.getTransitionalPagesName(rootPage, "_root");
            for (String pageName : transitionalPagesName) {
                String pathName = this._userDirectoryPageHandler.getPathName(pageName);
                children.add(new TransitionalPage(rootPage, pageName, pathName, this._resolver, this._userDirectoryPageHandler, this._synchronizableContentsCollectionDAO, this._skinManager, this._sccHelper, this._pageDataTypeExtensionPoint, this._pageDataTypeExtensionPoint, this._serviceExtensionPoint, this._pageDataTypeExtensionPoint));
            }
        } else {
            Map<String, String> userPagesContent = this._userDirectoryPageHandler.getUserPagesContent(rootPage, "_root");
            for (String contentId : userPagesContent.values()) {
                if (this._resolver.hasAmetysObjectForId(contentId)) {
                    Content content = (Content)this._resolver.resolveById(contentId);
                    children.add(new UserPage(rootPage, content, "_root", this._resolver, this._userDirectoryPageHandler, this._synchronizableContentsCollectionDAO, this._skinManager, this._sccHelper, this._pageDataTypeExtensionPoint, this._pageDataTypeExtensionPoint, this._serviceExtensionPoint, this._pageDataTypeExtensionPoint));
                    continue;
                }
                this.getLogger().info("Content '{}' is stil referenced, but it does not exists anymore");
            }
        }
        return new CollectionIterable(children);
    }

    public Page getChild(JCRAmetysObject parent, String childName) {
        if (!(parent instanceof Page)) {
            throw new IllegalArgumentException("The holder of the user directory virtual pages should be a page.");
        }
        Page rootPage = (Page)parent;
        int intialDepth = this._userDirectoryPageHandler.getDepth(rootPage);
        if (intialDepth > 0) {
            String name;
            SortedSet<String> transitionalPagesName = this._userDirectoryPageHandler.getTransitionalPagesName(rootPage, "_root");
            if (transitionalPagesName.contains(name = this._userDirectoryPageHandler.getName(childName))) {
                return new TransitionalPage(rootPage, name, childName, this._resolver, this._userDirectoryPageHandler, this._synchronizableContentsCollectionDAO, this._skinManager, this._sccHelper, this._pageDataTypeExtensionPoint, this._pageDataTypeExtensionPoint, this._serviceExtensionPoint, this._pageDataTypeExtensionPoint);
            }
            throw new UnknownAmetysObjectException("No transitional page named " + childName);
        }
        Map<String, String> userPagesContent = this._userDirectoryPageHandler.getUserPagesContent(rootPage, "_root");
        if (userPagesContent.containsKey(childName)) {
            Content content = (Content)this._resolver.resolveById(userPagesContent.get(childName));
            return new UserPage(rootPage, content, "_root", this._resolver, this._userDirectoryPageHandler, this._synchronizableContentsCollectionDAO, this._skinManager, this._sccHelper, this._pageDataTypeExtensionPoint, this._pageDataTypeExtensionPoint, this._serviceExtensionPoint, this._pageDataTypeExtensionPoint);
        }
        throw new UnknownAmetysObjectException("No user content named " + childName);
    }

    public boolean hasChild(JCRAmetysObject parent, String childName) {
        if (!(parent instanceof Page)) {
            throw new IllegalArgumentException("The holder of the user directory virtual pages should be a page.");
        }
        Page rootPage = (Page)parent;
        int intialDepth = this._userDirectoryPageHandler.getDepth(rootPage);
        if (intialDepth > 0) {
            SortedSet<String> transitionalPagesName = this._userDirectoryPageHandler.getTransitionalPagesName(rootPage, "_root");
            String name = this._userDirectoryPageHandler.getName(childName);
            return transitionalPagesName.contains(name);
        }
        Map<String, String> userPagesContent = this._userDirectoryPageHandler.getUserPagesContent(rootPage, childName);
        return userPagesContent.containsKey(childName);
    }
}

