/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.signup;

import com.google.common.collect.Multimap;
import com.opensymphony.workflow.WorkflowException;
import java.util.Map;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.core.user.User;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebConstants;
import org.ametys.web.content.FOContentCreationHelper;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.usermanagement.UserManagementException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang.StringUtils;

public class UserSignupManager
extends org.ametys.web.usermanagement.UserSignupManager {
    protected int _initWorkflowActionId;
    protected String _workflowName;
    private Context _context;
    private ContentTypeExtensionPoint _contentTypeEP;
    private FOContentCreationHelper _foHelper;

    public void contextualize(Context context) throws ContextException {
        super.contextualize(context);
        this._context = context;
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._contentTypeEP = (ContentTypeExtensionPoint)serviceManager.lookup(ContentTypeExtensionPoint.ROLE);
        this._foHelper = (FOContentCreationHelper)serviceManager.lookup(FOContentCreationHelper.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this._initWorkflowActionId = Integer.valueOf(configuration.getChild("user-init-action-id").getValue());
        this._workflowName = configuration.getChild("user-workflow-name").getValue();
    }

    protected Request _getRequest() {
        return ContextHelper.getRequest((Context)this._context);
    }

    public void validationBeforeSignup(Multimap<String, I18nizableText> errors) {
        ContentType userContentType;
        String userContentTypeId;
        Request request = this._getRequest();
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(WebConstants.REQUEST_ATTR_ZONEITEM);
        if (zoneItem != null && StringUtils.isNotBlank((String)(userContentTypeId = (String)zoneItem.getServiceParameters().getValue("user-content-type"))) && (userContentType = (ContentType)this._contentTypeEP.getExtension(userContentTypeId)) != null) {
            Map userValues = this._foHelper.getAndValidateFormValues(request, userContentType, "signup", errors);
            if (errors.isEmpty()) {
                request.setAttribute(UserSignupManager.class.getName() + "$userValues", (Object)userValues);
            }
        }
    }

    public void additionalSignupOperations(User createdUser, Multimap<String, I18nizableText> errors) throws UserManagementException {
        ContentType userContentType;
        String userContentTypeId;
        super.additionalSignupOperations(createdUser, errors);
        Request request = this._getRequest();
        String siteName = (String)request.getAttribute("site");
        String language = (String)request.getAttribute("sitemapLanguage");
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(WebConstants.REQUEST_ATTR_ZONEITEM);
        if (zoneItem != null && StringUtils.isNotBlank((String)(userContentTypeId = (String)zoneItem.getServiceParameters().getValue("user-content-type"))) && (userContentType = (ContentType)this._contentTypeEP.getExtension(userContentTypeId)) != null) {
            Map userValues = (Map)request.getAttribute(UserSignupManager.class.getName() + "$userValues");
            userValues.put("user", createdUser.getIdentity());
            if (errors.isEmpty()) {
                try {
                    this._foHelper.createAndEditContent(this._initWorkflowActionId, userContentType.getId(), siteName, createdUser.getFullName(), createdUser.getFullName(), language, userValues, this._workflowName, null);
                }
                catch (WorkflowException | AmetysRepositoryException e) {
                    this.getLogger().error("Unable to create the user content for user '{}' after sign up", (Object)createdUser, (Object)e);
                    errors.put((Object)"global", (Object)new I18nizableText("PLUGINS_USER_DIRECTORY_SIGNUP_SERVICE_CREATE_CONTENT_ERROR"));
                }
            }
        }
    }
}

