/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.contentio.synchronize.AbstractSimpleSynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.impl.LDAPCollectionHelper;
import org.ametys.plugins.core.impl.user.directory.JdbcUserDirectory;
import org.ametys.plugins.core.impl.user.directory.LdapUserDirectory;
import org.ametys.plugins.userdirectory.DeleteUserComponent;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPopulationSynchronizableContentsCollection
extends AbstractSimpleSynchronizableContentsCollection {
    protected static final String __PARAM_POPULATION_ID = "populationId";
    protected static final String __PARAM_FIRSTNAME_ATTRIBUTE_NAME = "firstname";
    protected static final String __PARAM_LASTNAME_ATTRIBUTE_NAME = "lastname";
    protected static final String __PARAM_EMAIL_ATTRIBUTE_NAME = "email";
    protected static final String __PARAM_MAPPING = "mapping";
    protected static final String __PARAM_ADDITIONAL_SEARCH_FILTER = "additionalSearchFilter";
    protected static final String __PARAM_MAPPING_SYNCHRO = "synchro";
    protected static final String __PARAM_MAPPING_ATTRIBUTE_REF = "metadata-ref";
    protected static final String __PARAM_MAPPING_ATTRIBUTE_PREFIX = "attribute-";
    protected static final Logger _LOGGER = LoggerFactory.getLogger(UserPopulationSynchronizableContentsCollection.class);
    private static final int __LDAP_DEFAULT_PAGE_SIZE = 1000;
    protected UserPopulationDAO _userPopulationDAO;
    protected ServiceManager _manager;
    protected JSONUtils _jsonUtils;
    protected DeleteUserComponent _deleteUserComponent;
    protected Map<String, Map<String, List<String>>> _mapping;
    protected Set<String> _syncFields;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._userPopulationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
        this._deleteUserComponent = (DeleteUserComponent)manager.lookup(DeleteUserComponent.ROLE);
        this._manager = manager;
    }

    public boolean handleRightAssignmentContext() {
        return false;
    }

    protected void configureDataSource(Configuration configuration) throws ConfigurationException {
        this._mapping = new HashMap<String, Map<String, List<String>>>();
        this._syncFields = new HashSet<String>();
        String mappingAsString = (String)this.getParameterValues().get(__PARAM_MAPPING);
        if (StringUtils.isNotEmpty((String)mappingAsString)) {
            List mappingAsList = this._jsonUtils.convertJsonToList(mappingAsString);
            for (Object object : mappingAsList) {
                Map field = (Map)object;
                String attributeRef = (String)field.get(__PARAM_MAPPING_ATTRIBUTE_REF);
                String prefix = __PARAM_MAPPING_ATTRIBUTE_PREFIX;
                for (String prefixedUserDirectoryKey : this._getUserDirectoryKeys(field, prefix)) {
                    String userDirectoryKey = prefixedUserDirectoryKey.substring(prefix.length());
                    if (!this._mapping.containsKey(userDirectoryKey)) {
                        this._mapping.put(userDirectoryKey, new HashMap());
                    }
                    String[] attributes = ((String)field.get(prefixedUserDirectoryKey)).split(",");
                    Map<String, List<String>> userDirectoryMapping = this._mapping.get(userDirectoryKey);
                    userDirectoryMapping.put(attributeRef, Arrays.asList(attributes));
                }
                boolean isSynchronized = field.containsKey(__PARAM_MAPPING_SYNCHRO) ? (Boolean)field.get(__PARAM_MAPPING_SYNCHRO) : false;
                if (!isSynchronized) continue;
                this._syncFields.add(attributeRef);
            }
        }
    }

    protected void configureSearchModel() {
        _LOGGER.info("Currently, SCC '{}' cannot define a search model", (Object)UserPopulationSynchronizableContentsCollection.class.getName());
    }

    protected List<ModifiableContent> _internalPopulate(Logger logger) {
        ArrayList<ModifiableContent> contents = new ArrayList<ModifiableContent>();
        UserPopulation population = this._userPopulationDAO.getUserPopulation(this.getPopulationId());
        for (UserDirectory userDirectory : population.getUserDirectories()) {
            HashMap<String, UserDirectory> searchParams = new HashMap<String, UserDirectory>();
            searchParams.put("userDirectory", userDirectory);
            contents.addAll(this._importOrSynchronizeContents(searchParams, false, logger));
        }
        return contents;
    }

    protected Map<String, Map<String, Object>> searchLDAP(LdapUserDirectory userDirectory, Map<String, Object> searchParameters, int offset, int limit, Logger logger, boolean getRemoteValues) {
        String emailAttribute;
        String lastNameAttribute;
        Map results = new HashMap();
        Map ldapParameterValues = userDirectory.getParameterValues();
        String dataSourceId = (String)ldapParameterValues.get("runtime.users.ldap.datasource");
        String relativeDN = (String)ldapParameterValues.get("runtime.users.ldap.peopleDN");
        String filter = (String)ldapParameterValues.get("runtime.users.ldap.baseFilter");
        String searchScope = (String)ldapParameterValues.get("runtime.users.ldap.scope");
        String loginAttr = (String)ldapParameterValues.get("runtime.users.ldap.loginAttr");
        Map udMapping = this._mapping.getOrDefault(userDirectory.getId(), new HashMap());
        udMapping.put(this.getLoginAttributeName(), List.of(loginAttr));
        String firstNameAttribute = this.getFirstNameAttributeName();
        if (StringUtils.isNotBlank((String)firstNameAttribute)) {
            String firstNameAttr = (String)ldapParameterValues.get("runtime.users.ldap.firstnameAttr");
            udMapping.put(firstNameAttribute, List.of(firstNameAttr));
        }
        if (StringUtils.isNotBlank((String)(lastNameAttribute = this.getLastNameAttributeName()))) {
            String lastNameAttr = (String)ldapParameterValues.get("runtime.users.ldap.lastnameAttr");
            udMapping.put(lastNameAttribute, List.of(lastNameAttr));
        }
        if (StringUtils.isNotBlank((String)(emailAttribute = this.getEmailAttributeName()))) {
            String emailAttr = (String)ldapParameterValues.get("runtime.users.ldap.emailAttr");
            udMapping.put(emailAttribute, List.of(emailAttr));
        }
        try {
            Object filtersReduced;
            String additionalSearchFilter;
            LDAPCollectionHelper ldapHelper = (LDAPCollectionHelper)this._manager.lookup(LDAPCollectionHelper.ROLE);
            ldapHelper._delayedInitialize(dataSourceId);
            ArrayList<Object> filters = new ArrayList<Object>();
            if (StringUtils.isNotEmpty((String)filter)) {
                filters.add(filter);
            }
            if (searchParameters != null) {
                for (String parameterName : searchParameters.keySet()) {
                    filters.add(parameterName + "=" + searchParameters.get(parameterName));
                }
            }
            if (StringUtils.isNotEmpty((String)(additionalSearchFilter = this.getAdditionalSearchFilter()))) {
                filters.add(additionalSearchFilter);
            }
            if (!((String)(filtersReduced = filters.stream().filter(StringUtils::isNotEmpty).map(s -> "(" + s + ")").reduce("", (s1, s2) -> s1 + s2))).isEmpty()) {
                filtersReduced = "(&" + (String)filtersReduced + ")";
            }
            results = ldapHelper.search(this.getId(), 1000, relativeDN, (String)filtersReduced, searchScope, offset, limit, udMapping, loginAttr, logger);
            if (getRemoteValues) {
                Map organizedResults = this._sccHelper.organizeRemoteValuesByAttribute(results, udMapping);
                ldapHelper.transformTypedAttributes(organizedResults, this.getContentType(), udMapping.keySet());
                results = organizedResults;
            }
            this._nbError = ldapHelper.getNbErrors();
            this._hasGlobalError = ldapHelper.hasGlobalError();
        }
        catch (Exception e) {
            throw new RuntimeException("An error occured when importing from LDAP UserDirectory", e);
        }
        return results;
    }

    protected Map<String, Map<String, Object>> internalSearch(Map<String, Object> searchParameters, int offset, int limit, List<Object> sort, Logger logger) {
        return this._internalSearch(searchParameters, offset, limit, sort, logger, false);
    }

    private Map<String, Map<String, Object>> _internalSearch(Map<String, Object> searchParameters, int offset, int limit, List<Object> sort, Logger logger, boolean getRemoteValues) {
        LinkedHashMap<String, Map<String, Object>> results = new LinkedHashMap<String, Map<String, Object>>();
        List userDirectories = new ArrayList<UserDirectory>();
        if (searchParameters.containsKey("userDirectory")) {
            userDirectories.add((UserDirectory)searchParameters.get("userDirectory"));
            searchParameters.remove("userDirectory");
        } else {
            UserPopulation population = this._userPopulationDAO.getUserPopulation(this.getPopulationId());
            userDirectories = population.getUserDirectories();
        }
        for (UserDirectory userDirectory : userDirectories) {
            if (userDirectory instanceof LdapUserDirectory) {
                results.putAll(this.searchLDAP((LdapUserDirectory)userDirectory, searchParameters, offset, limit, logger, getRemoteValues));
                continue;
            }
            if (userDirectory instanceof JdbcUserDirectory) {
                logger.warn("Population with SQL datasource is not implemented.");
                continue;
            }
            Map<String, Map> userAsSearchResults = userDirectory.getUsers().stream().map(this::_userToSearchResult).collect(Collectors.toMap(m -> (String)((List)m.get(this.getIdField())).get(0), m -> m));
            results.putAll(userAsSearchResults);
        }
        return results;
    }

    protected Map<String, Object> _userToSearchResult(User user) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put(this.getIdField(), List.of(user.getIdentity().getLogin()));
        String firstName = user.getFirstName();
        json.put(this.getFirstNameAttributeName(), StringUtils.isNotBlank((String)firstName) ? List.of(firstName) : List.of());
        String lastName = user.getLastName();
        json.put(this.getLastNameAttributeName(), StringUtils.isNotBlank((String)lastName) ? List.of(lastName) : List.of());
        String email = user.getEmail();
        json.put(this.getEmailAttributeName(), StringUtils.isNotBlank((String)email) ? List.of(email) : List.of());
        return json;
    }

    protected Map<String, Map<String, List<Object>>> getRemoteValues(Map<String, Object> searchParameters, Logger logger) {
        return this._internalSearch(searchParameters, 0, Integer.MAX_VALUE, null, logger, true);
    }

    protected Map<String, Object> getAdditionalAttributeValues(String idValue, Content content, Map<String, Object> additionalParameters, boolean create, Logger logger) {
        Map additionalRemoteValues = super.getAdditionalAttributeValues(idValue, content, additionalParameters, create, logger);
        UserIdentity user = new UserIdentity(idValue, this.getPopulationId());
        additionalRemoteValues.put("user", user);
        return additionalRemoteValues;
    }

    public String getPopulationId() {
        return (String)this.getParameterValues().get(__PARAM_POPULATION_ID);
    }

    public String getIdField() {
        return this.getLoginAttributeName();
    }

    public String getLoginAttributeName() {
        return "uniqueId";
    }

    public String getFirstNameAttributeName() {
        return (String)this.getParameterValues().get(__PARAM_FIRSTNAME_ATTRIBUTE_NAME);
    }

    public String getLastNameAttributeName() {
        return (String)this.getParameterValues().get(__PARAM_LASTNAME_ATTRIBUTE_NAME);
    }

    public String getEmailAttributeName() {
        return (String)this.getParameterValues().get(__PARAM_EMAIL_ATTRIBUTE_NAME);
    }

    public String getAdditionalSearchFilter() {
        return (String)this.getParameterValues().get(__PARAM_ADDITIONAL_SEARCH_FILTER);
    }

    public Set<String> getLocalAndExternalFields(Map<String, Object> additionalParameters) {
        return this._syncFields;
    }

    private Set<String> _getUserDirectoryKeys(Map<String, Object> field, String prefix) {
        return field.keySet().stream().filter(name -> name.startsWith(prefix)).collect(Collectors.toSet());
    }

    protected Map<String, Object> putIdParameter(String idValue) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (String userDirectory : this._mapping.keySet()) {
            List<String> remoteKeys = this._mapping.get(userDirectory).get(this.getIdField());
            if (remoteKeys == null || remoteKeys.size() <= 0) continue;
            parameters.put(userDirectory + "$" + remoteKeys.get(0), idValue);
        }
        return parameters;
    }

    protected int _deleteContents(List<Content> contentsToRemove, Logger logger) {
        return this._deleteUserComponent.deleteContentsWithLog(contentsToRemove, Map.of("sccId", this.getId()), Map.of(), logger);
    }
}

