/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.transformation.xslt;

import java.io.IOException;
import java.io.InputStream;
import org.ametys.cms.data.ExplorerFile;
import org.ametys.cms.data.File;
import org.ametys.cms.repository.Content;
import org.ametys.cms.transformation.ImageResolverHelper;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.ui.user.ProfileImageProvider;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.ametys.runtime.plugin.component.LogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.slf4j.Logger;

public class ResolveAvatarURIComponent
implements Serviceable,
Contextualizable,
LogEnabled,
PluginAware {
    public static final String USER_CONTENT_IMAGE_PATH = "illustration/image";
    private static SourceResolver _srcResolver;
    private static UserDirectoryHelper _userDirectoryHelper;
    private static Context _context;
    private static Logger _logger;
    private static String _pluginName;
    private static ProfileImageProvider _profileImageProvider;

    public void service(ServiceManager manager) throws ServiceException {
        _profileImageProvider = (ProfileImageProvider)manager.lookup(ProfileImageProvider.ROLE);
        _srcResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        _userDirectoryHelper = (UserDirectoryHelper)((Object)manager.lookup(UserDirectoryHelper.ROLE));
    }

    public void setLogger(Logger logger) {
        _logger = logger;
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        _pluginName = pluginName;
    }

    public void contextualize(Context context) throws ContextException {
        _context = context;
    }

    public static String resolve(String login, String populationId, String lang, int size) {
        boolean encodeBase64;
        Request request = ContextHelper.getRequest((Context)_context);
        boolean bl = encodeBase64 = request.getAttribute("forceBase64Encoding") != null ? (Boolean)request.getAttribute("forceBase64Encoding") : false;
        if (!encodeBase64) {
            return "_plugins/" + _pluginName + "/user/" + populationId + "/" + login + "/image_" + size;
        }
        return ResolveAvatarURIComponent._getAvatarAsBase64(new UserIdentity(login, populationId), size, lang);
    }

    private static String _getAvatarAsBase64(UserIdentity user, int size, String lang) {
        String string;
        block20: {
            if (user == null) {
                String string2;
                block19: {
                    Source source = _srcResolver.resolveURI("skin://resources/img/avatar.png");
                    InputStream dataIs = source.getInputStream();
                    try {
                        string2 = ImageResolverHelper.resolveImageAsBase64((InputStream)dataIs, (String)"image/png", (int)size, (int)size, (int)0, (int)0);
                        if (dataIs == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (dataIs != null) {
                                try {
                                    dataIs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            _logger.warn("Failed to retrieve generic avatar image from skin", (Throwable)e);
                            return "";
                        }
                    }
                    dataIs.close();
                }
                return string2;
            }
            Content userContent = _userDirectoryHelper.getUserContent(user, lang);
            if (userContent != null && userContent.hasValue(USER_CONTENT_IMAGE_PATH)) {
                File fileValue = (File)userContent.getValue(USER_CONTENT_IMAGE_PATH);
                if (fileValue instanceof ExplorerFile) {
                    return ResolveURIComponent.resolveCroppedImage((String)"explorer", (String)((ExplorerFile)fileValue).getResourceId(), (int)size, (int)size, (boolean)false, (boolean)false, (boolean)true);
                }
                String imgUri = "illustration/image?contentId=" + userContent.getId();
                return ResolveURIComponent.resolveCroppedImage((String)"attribute", (String)imgUri, (int)size, (int)size, (boolean)false, (boolean)false, (boolean)true);
            }
            ProfileImageProvider.UserProfileImage image = _profileImageProvider.getImage(user, null, size, 0);
            String filename = (String)StringUtils.defaultIfEmpty((CharSequence)image.getFilename(), (CharSequence)(user.getLogin() + ".png"));
            String format = FilenameUtils.getExtension((String)filename);
            InputStream dataIs = image.getInputstream();
            try {
                string = ImageResolverHelper.resolveImageAsBase64((InputStream)dataIs, (String)("image/" + format), (int)size, (int)size, (int)0, (int)0);
                if (dataIs == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (dataIs != null) {
                        try {
                            dataIs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ProcessingException e) {
                    _logger.warn("Failed to compute generic avatar for user {}", (Object)UserIdentity.userIdentityToString((UserIdentity)user), (Object)e);
                    return "";
                }
            }
            dataIs.close();
        }
        return string;
    }
}

