/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.transformation.xslt;

import org.ametys.cms.repository.Content;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.ametys.plugins.userdirectory.page.UserDirectoryPageResolver;
import org.ametys.plugins.userdirectory.page.UserPage;
import org.ametys.web.transformation.xslt.AmetysXSLTHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang.StringUtils;

public class UserXSLTHelper
extends AmetysXSLTHelper {
    protected static SynchronizableContentsCollectionDAO _synchronizableContentsCollectionDAO;
    protected static UserDirectoryPageResolver _userDirectoryPageResolver;
    protected static UserDirectoryHelper _userDirectoryHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        _synchronizableContentsCollectionDAO = (SynchronizableContentsCollectionDAO)manager.lookup(SynchronizableContentsCollectionDAO.ROLE);
        _userDirectoryPageResolver = (UserDirectoryPageResolver)((Object)manager.lookup(UserDirectoryPageResolver.ROLE));
        _userDirectoryHelper = (UserDirectoryHelper)((Object)manager.lookup(UserDirectoryHelper.ROLE));
    }

    public static String getUserContent(String lang, String userIdentity) {
        if (StringUtils.isBlank((String)userIdentity)) {
            return null;
        }
        UserIdentity user = UserIdentity.stringToUserIdentity((String)userIdentity);
        Content userContent = _userDirectoryHelper.getUserContent(user, lang);
        if (userContent != null) {
            return userContent.getId();
        }
        return null;
    }

    public static String getCurrentUserContent(String lang) {
        UserIdentity currentUser = _currentUserProvider.getUser();
        if (currentUser == null) {
            return null;
        }
        Content userContent = _userDirectoryHelper.getUserContent(currentUser, lang);
        if (userContent != null) {
            return userContent.getId();
        }
        return null;
    }

    public static String getCurrentUserPage(String lang) {
        String contentId = UserXSLTHelper.getCurrentUserContent(lang);
        if (contentId != null) {
            return UserXSLTHelper.getUserPage(contentId);
        }
        return null;
    }

    public static String getUserPage(String contentId) {
        String siteName = UserXSLTHelper.site();
        return UserXSLTHelper.getUserPage(contentId, siteName);
    }

    public static String getUserPage(String contentId, String siteName) {
        if (contentId == null) {
            return null;
        }
        Content content = (Content)_ametysObjectResolver.resolveById(contentId);
        if (content == null) {
            return null;
        }
        UserPage userPage = _userDirectoryPageResolver.getUserPage(content, StringUtils.isBlank((String)siteName) ? UserXSLTHelper.site() : siteName, UserXSLTHelper.lang());
        return userPage != null ? userPage.getId() : null;
    }
}

