<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
                extension-element-prefixes="math ametys resolver escaper">
    
    <xsl:import href="service:web://pages/services/user-signup/signup_3.5.xsl"/>
    <xsl:import href="service:web://pages/services/contenttype/helper/form.xsl"/>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="strong-password-head-js"/>
        
        <xsl:call-template name="contenttype-form-header">
            <xsl:with-param name="view" select="/user-signup/view"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="continue-signup-fields">
        <xsl:call-template name="firstname-field">
            <xsl:with-param name="value" select="/user-signup/@firstname"/>
        </xsl:call-template>
        <xsl:call-template name="lastname-field">
            <xsl:with-param name="value" select="/user-signup/@lastname"/>
        </xsl:call-template>
        
        <xsl:call-template name="password-form-fields">
            <xsl:with-param name="uniqueId" select="$uniqueId"/>
            <xsl:with-param name="email" select="/user-signup/@email"/>
            <xsl:with-param name="token" select="/user-signup/@token"/>
            <xsl:with-param name="errors" select="/user-signup/errors"/>
        </xsl:call-template>
        
        <xsl:call-template name="user-fields"/>
        
        <xsl:if test="normalize-space($tos-mode) = 'CONTENT' and /user-signup/tos/content">
            <xsl:call-template name="tos-content">
                <xsl:with-param name="tos-content-id" select="$tos-content-id"/>
            </xsl:call-template>
        </xsl:if>
        
        <xsl:if test="normalize-space($tos-mode) != 'NONE'">
            <xsl:call-template name="tos-field">
                <xsl:with-param name="tos-mode" select="$tos-mode"/>
                <xsl:with-param name="tos-page-id" select="$tos-page-id"/>
                <xsl:with-param name="tos-link-label" select="$tos-link-label"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="user-fields">
        <xsl:apply-templates select="/user-signup/view/*[@name != 'firstname' and @name != 'lastname']" mode="contenttype-form-field">
            <xsl:with-param name="uniqueId" select="$uniqueId"/>
            <xsl:with-param name="values" select="/user-signup/user-inputs"/>
            <xsl:with-param name="contentValues" select="/user-signup/items"/>
            <xsl:with-param name="errors" select="/user-signup/errors/field[@name != 'lastname' and @name != 'firstname' and @name != 'email' and @name != 'captcha' and @name != 'tos' and @name != 'password']"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="metadata[@name ='email']" mode="contenttype-form-field">
        <xsl:param name="fieldId" select="translate(@path, '/', '-')"/>
        <xsl:param name="fieldName" select="translate(@path, '/', '.')"/>
        <xsl:param name="values"/>
        <xsl:param name="errors" />
        <xsl:param name="uniqueId" />
        <xsl:param name="value" select="$values/*[local-name() = $fieldName]"/>
        
        <input id="{$fieldId}-{$uniqueId}" type="hidden" name="email" value="{$values/email}"/>
    </xsl:template>   
    
    <xsl:template match="metadata[@type ='user']" mode="contenttype-form-field"/>
    
    <xsl:template name="form-attributes">
        <xsl:if test="/user-signup/view//metadata[@type = 'file' or @type = 'binary']">
            <xsl:attribute name="enctype">multipart/form-data</xsl:attribute>
        </xsl:if>
    </xsl:template>
   
</xsl:stylesheet>
