/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * This class is a singleton to set the root page of a organisation chart
 */
Ext.define('Ametys.plugins.userdirectory.SetOrganisationChartRootAction', {
    singleton: true,
    
    /**
     * Opens confirm box to set/remove the selected page as a root of a organisation chart.
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
     * @param {Boolean} state The toggle state
     */
    act: function(controller, state)
    {
        var pageId = controller.getMatchingTargets()[0].getParameters().id;
    	
        if (!state) //We remove the organisation chart root
        {
        	Ametys.Msg.confirm("{{i18n PLUGINS_USER_DIRECTORY_SET_ORGANISATION_CHART_ROOT_CONFIRM_TITLE}}",
        			"{{i18n PLUGINS_USER_DIRECTORY_SET_ORGANISATION_CHART_ROOT_CONFIRM_REMOVE_ROOT_MSG}}",
        			Ext.bind(function(btn)
					{
        				if (btn == 'yes')
        				{
        					controller.serverCall(
        							'removeOrganisationChartRoot', 
        							[pageId], 
        							Ext.bind(this._setOrganisationChartRootCb, this), 
        							{waitMessage: true, errorMessage: true, arguments: {pageId: pageId}}
        					);
        				}
					}, this),
					this
        	);
        }
        else //We set the organisation chart root
        {
        	Ametys.Msg.confirm("{{i18n PLUGINS_USER_DIRECTORY_SET_ORGANISATION_CHART_ROOT_CONFIRM_TITLE}}",
        			"{{i18n PLUGINS_USER_DIRECTORY_SET_ORGANISATION_CHART_ROOT_CONFIRM_SET_ROOT_MSG}}",
        			Ext.bind(function(btn)
					{
        				if (btn == 'yes')
        				{
        					controller.serverCall(
        							'setOrganisationChartRoot', 
        							[pageId], 
        							Ext.bind(this._setOrganisationChartRootCb, this), 
        							{waitMessage: true, errorMessage: true, arguments: {pageId: pageId}}
        					);
        				}
					}, this),
					this
        	);
        }
    },
    
    /**
     * @private
     * Callback function for the server call of the set or remove of an organisation chart root page
     * @param {Object} response The server response
     * @param {Object} arguments The arguments
     */
    _setOrganisationChartRootCb: function(response, arguments)
    {
    	if (response && !response.error)
        {
	        Ext.create("Ametys.message.Message", {
	            type: Ametys.message.Message.MODIFIED,
	            parameters: {major: true},
	            targets: {
	                id: Ametys.message.MessageTarget.PAGE,
	                parameters: {
	                    ids: [arguments.pageId]
	                }
	            }
	        });
        }
    	else if (response.error && response.error == "already-exist")
        {
            Ametys.Msg.show({
                title: "{{i18n PLUGINS_USER_DIRECTORY_SET_ORGANISATION_CHART_ROOT_PAGE_DIALOG_ERROR_TITLE}}",
                msg: "{{i18n PLUGINS_USER_DIRECTORY_SET_ORGANISATION_CHART_ROOT_PAGE_DIALOG_ALREADY_EXIST_ERROR_DESCRIPTION}}",
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    	else if (response.error && response.error == "no-root")
        {
            Ametys.Msg.show({
                title: "{{i18n PLUGINS_USER_DIRECTORY_SET_ORGANISATION_CHART_ROOT_PAGE_DIALOG_ERROR_TITLE}}",
                msg: "{{i18n PLUGINS_USER_DIRECTORY_SET_ORGANISATION_CHART_ROOT_PAGE_DIALOG_ERROR_DESCRIPTION}}",
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    }
});
