/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
 AmetysOrganizationChart = {
    
    selector: '.organization-chart',
    
    contextPath: null,
    
    siteName: null,
    
    orgUnitViewName: 'main',

    /**
     * Initialize the chart
     * @param {String} selector the jquery selector for root element
     * @param {String} contextPath the context path
     * @param {String} [orgUnitViewName=main] The view to use for orgunit popup 
     */
    initialize: function (selector, contextPath, siteName, orgUnitViewName)
    {
        AmetysOrganizationChart.selector = selector || '.organization-chart';
        AmetysOrganizationChart.contextPath = contextPath;
        AmetysOrganizationChart.siteName = siteName;
        AmetysOrganizationChart.orgUnitViewName = orgUnitViewName || 'main';
        
        document.addEventListener("click", function (e) {
            $j(AmetysOrganizationChart.selector + ' .results').hide();
        });
        
        setTimeout(function () {
            document
                .querySelector(AmetysOrganizationChart.selector + " .results")
                .addEventListener("click", function getDetails(evt) {
                    evt.stopPropagation();
                });
        }, 600);

    },
    
    getRandomInt: function(max) 
    {
        return Math.floor(Math.random() * Math.floor(max));
    },
    
    sleep: function(ms) {
	    return new Promise(resolve => setTimeout(resolve, ms));
	},
    
    closeOrgaUnit: function() 
    {
	    $j('.overlay').removeClass('active');
	    $j('.view-organizationChart').removeClass('open');
	    // $j('.header').show();
	},
    
    openOrga: async function(e) 
    {

	    $j('ul.open:not(.orga)').children('li').hide();
	    $j('.orga').children('ul.open').removeClass('open');
	    $j('.open-orga.active').removeClass('active');
	    $j('.orga').find('.item').removeClass('closed');
	    $j('.orga').find('ul').removeClass('removeMarginLeft');
	
	
	    $j('.results').hide();
	    var open = $j(e).attr('data-open');
	    var parents = $j(`#${open}`).parentsUntil();
	    var i = 0;
	    var ids = [];
	    parents.each(function () {
	        i++;
	
	        if (i > 2) {
	            if ($j(this).prop("tagName") == "LI") {
	                let id = $j(this).children('.item').attr('id');
	                ids.push(id);
	            }
	        }
	
	    })
	    ids.reverse();
	
	    for (const i of ids) {
	        $j(`#${i}`).children('.link').trigger('click');
	        await AmetysOrganizationChart.sleep(1200);
	
	    }
	
	    $j(`#${open}`).trigger('click');
	},
    
    searchOrga: function()
    {
        // empty results
        $j(AmetysOrganizationChart.selector + ' .results').html('');
        
        var search = $j(AmetysOrganizationChart.selector + " #search").val().toLowerCase();
	    var nbResults = 0;
	    if (search.length >= 3) {
	        $j(AmetysOrganizationChart.selector + ' .orga').find('.item').each(function () {
	            var open = 'open' + AmetysOrganizationChart.getRandomInt(9999999999);
	            $j(this).attr('id', open);
	
	            var hasResult = false;
	            $j(this).find('.searchable').each(function () {
	                var searchable = $j(this).html().toLowerCase();
	
	                let myReg = new RegExp(search + ".*")
	                let myMatch = searchable.match(myReg)
	                if (myMatch) {
	                    hasResult = true;
	                }
	            })
	
	            if (hasResult) {
	                nbResults++;
	                if ($j(this).find('.title').length != 0) {
	                    var show = $j(this).find('.title').html();
	                    $j(AmetysOrganizationChart.selector + ' .results').append(
	                        `<a href="javascript:void(0)" class="serviceResult" onclick="AmetysOrganizationChart.openOrga(this)" data-open="${open}"><i class="fas fa-chevron-right"></i> <div class="title">${show}</div></a>`
	                    );
	
	                    if ($j(this).find('.name').length != 0) {
	                        var show = $j(this).find('.name').html();
	                        var fonction = $j(this).find('.function').html();
	                        var picto = $j(this).find('.picto').html();
	                        $j(AmetysOrganizationChart.selector + ' .results').append(
	                            `<a href="javascript:void(0)" class="userResult" onclick="AmetysOrganizationChart.openOrga(this)" data-open="${open}">${picto} <div class="flex"><span class="name">${show}</span><span class="function">${fonction}</div></a>`
	                        );
	
	                    }
	                } else {
	                    var show = $j(this).find('.name').html();
	                    var fonction = $j(this).find('.function').html();
	                    var picto = $j(this).find('.picto').html();
	                    $j(AmetysOrganizationChart.selector + ' .results').append(
	                        `<a href="javascript:void(0)" class="userResult" onclick="AmetysOrganizationChart.openOrga(this)" data-open="${open}">${picto} <div class="flex"><span class="name">${show}</span><span class="function">${fonction}</div></a>`
	                    );
	
	                }
	
	            }
	
	        });
	    }
	
	    if (nbResults == 0) {
	        $j(AmetysOrganizationChart.selector + ' .results').hide(); // no results
	    } else {
	
	        $j(AmetysOrganizationChart.selector + ' .results').show();
	    }
    }
}

jQuery(document).ready(function() {
    $j(".open-orga").click(function () {

            var self = this;

            var nextUl = $j(this).parent().next('ul');
            var orga = $j(this).closest('.level-1-orga');
            $j(this).parent().removeClass('closed');

            // Si autre branche de niveau on close tout
            $j('.level-1-orga').not(orga).find('li').hide();
            $j('.level-1-orga').not(orga).find('.open-orga').removeClass('active');
            $j('.level-1-orga').not(orga).find('.open-orga').parent().removeClass('active');
            $j('.level-1-orga').not(orga).find('ul').removeClass('open').removeClass('closed');

            var ulOrga = $j(orga).parent();

            if ($j(this).hasClass('active')) {
                $j(this).parent().parent().parent().find('ul').removeClass('closed').removeClass('removeMarginLeft');
                $j(this).parent().parent().parent().find('.item').removeClass('closed').removeClass('active');

                $j(this).removeClass('active');
                $j(this).parent().removeClass('active');
                $j(nextUl).children('li').hide();
                $j(nextUl).find('ul').removeClass('open').removeClass('removeMarginLeft');
                $j(nextUl).removeClass('open');
                $j(nextUl).find('li').hide();
                $j(nextUl).find('ul').find('li').hide();

                var count = 0;
                $j(orga).find('ul').each(function () {
                    if ($j(this).hasClass('open')) {
                        count++;
                    }
                });

                var lastLiInUl = $j(nextUl).parent().parent('.open').children('li:last');

                setTimeout(function () {

                    $j(orga).find('ul.open').each(function () {
                        var positionUl = $j(this).offset();
                        var positionLiLast = $j(this).children('li:last').offset();

                        var lastLiHeight = $j(this).children('li:last').children('.item:first')
                            .height();
                        var diff = positionLiLast.top - positionUl.top;

                        if (lastLiHeight == 125) {
                            diff = diff + lastLiHeight - 23;
                        } else {
                            diff = diff + lastLiHeight + 5;
                        }
                        $j(this).attr('style', '--height:' + diff + 'px');
                    });
                }, 300);

                if (count < 3) {
                    if ($j(orga).first('.open:first').parent('ul').hasClass('orga') && $j(orga).find('.closed')
                        .length == 0) {

                        $j('.level-1-orga').children('.item').show();
                        $j(ulOrga).addClass('open');
                        $j('.level-1-orga').children('.item').removeClass('closed');
                        $j('.level-1-orga').children('.item').children('.open').removeClass('removeMarginLeft');

                    }

                    if ($j(nextUl).prev().parent().hasClass('level-1-orga')) {

                    } else {

                        if (count == 2) {

                            var prev = $j(nextUl).closest('.closed');

                            if (prev.length == 0) {
                                $j('.level-1-orga').children('.item').show();
                                $j(ulOrga).addClass('open');
                                $j('.level-1-orga').children('.item').removeClass('closed');
                                $j('.level-1-orga').children('.open').removeClass('removeMarginLeft');
                            }


                            $j(nextUl).closest('.closed').children('li').children('.item').removeClass(
                                'closed');
                            $j(nextUl).closest('.closed').children('li').children('ul').removeClass(
                                'removeMarginLeft');
                            $j(nextUl).closest('.closed').children('li').children('.item').show();
                            $j(nextUl).closest('.closed').removeClass('closed').addClass('open');


                        }

                        if (count == 1) {
                            var prevUl1 = $j(nextUl).closest('.closed');
                            $j(prevUl1).children('li').children('.item').show();
                            $j(prevUl1).removeClass('closed').addClass('open');

                            $j(prevUl1).children('li').children('.item').removeClass('closed');
                            $j(prevUl1).children('li').children('ul').removeClass('removeMarginLeft');


                            var prevUl2 = $j(prevUl1).closest('.closed');
                            $j(prevUl2).children('li').children('.item').show();
                            $j(prevUl2).removeClass('closed').addClass('open');

                            $j(prevUl2).children('li').children('.item').removeClass('closed');
                            $j(prevUl2).children('li').children('ul').removeClass('removeMarginLeft');

                            if (prevUl2.length == 0) {
                                $j('.level-1-orga').children('.item').show();
                                $j(ulOrga).addClass('open');
                                $j('.level-1-orga').children('.item').removeClass('closed');
                                $j('.level-1-orga').children('.open').removeClass('removeMarginLeft');
                            }

                        }


                        if (count == 0) {
                            var prevUl1 = $j(nextUl).closest('.closed');
                            $j(prevUl1).children('li').children('.item').show();
                            $j(prevUl1).removeClass('closed').addClass('open');

                            $j(prevUl1).children('li').children('.item').removeClass('closed');
                            $j(prevUl1).removeClass('removeMarginLeft');


                            var prevUl2 = $j(prevUl1).closest('.closed');
                            $j(prevUl2).children('li').children('.item').show();
                            $j(prevUl2).removeClass('closed').addClass('open');

                            $j(prevUl2).children('li').children('.item').removeClass('closed');
                            $j(prevUl2).removeClass('removeMarginLeft');


                            if (prevUl2.length == 0) {
                                $j('.level-1-orga').children('.item').show();
                                $j(ulOrga).addClass('open');
                                $j('.level-1-orga').children('.item').removeClass('closed');
                                $j('.level-1-orga').children('.item').children('.open').removeClass(
                                    'removeMarginLeft');
                            }


                            var prevUl3 = $j(prevUl2).closest('.closed');
                            $j(prevUl3).children('li').children('.item').show();
                            $j(prevUl3).removeClass('closed').addClass('open');

                            $j(prevUl3).children('li').children('.item').removeClass('closed');
                            $j(prevUl3).removeClass('removeMarginLeft');

                            if (prevUl2.length == 0) {
                                $j('.level-1-orga').children('.item').show();
                                $j(ulOrga).addClass('open');
                                $j('.level-1-orga').children('.item').removeClass('closed');
                                $j('.level-1-orga').children('.item').children('.open').removeClass(
                                    'removeMarginLeft');
                            }


                        }

                    }
                }

            } else {

                var currentLi = $j(nextUl).parent();
                var currentOpen = $j(nextUl).parent().parent();
                $j(currentOpen).children('li').children('.open').children('li').hide()
                $j(currentOpen).children('li').find('.link').removeClass('active');
                $j(currentOpen).children('li').find('.link').parent().removeClass('active');
                $j(currentOpen).children('li').find('ul').removeClass('open').removeClass('removeMarginLeft');
                $j(currentOpen).children('li').find('ul').find('li').hide();

                $j(this).addClass('active');
                $j(this).parent().addClass('active');
                $j(nextUl).children('li').show();
                $j(nextUl).addClass('open');

                $j(nextUl).parent().parent('.open').removeAttr('style');

                var lastLiInUl = $j(nextUl).parent().parent('.open').children('li:last');


                setTimeout(function () {

                    $j(orga).find('ul.open').each(function () {


                        //$j('ul:not(.orga)').children('li').children('.item').attr('style',
                        // '--width: 0px');


                        var positionUl = $j(this).offset();
                        var positionLiLast = $j(this).children('li:last').offset();

                        var lastLiHeight = $j(this).children('li:last').children('.item:first')
                            .height();
                        var diff = positionLiLast.top - positionUl.top;


                        if (lastLiHeight == 125) {
                            diff = diff + lastLiHeight - 23;
                        } else {
                            diff = diff + lastLiHeight + 5;
                        }
                        $j(this).attr('style', '--height:' + diff + 'px');
                        setTimeout(function () {
                            $j('ul.open:not(.orga)').children('li').children('.item')
                                .attr('style', '--width: 45px');
                        }, 700);
                    });
                }, 0);

                setTimeout(function () {
                $j(orga).find('ul.open').each(function () {


                    //$j('ul:not(.orga)').children('li').children('.item').attr('style',
                    // '--width: 0px');


                    var positionUl = $j(this).offset();
                    var positionLiLast = $j(this).children('li:last').offset();

                    var lastLiHeight = $j(this).children('li:last').children('.item:first')
                        .height();
                    var diff = positionLiLast.top - positionUl.top;


                    if (lastLiHeight == 125) {
                        diff = diff + lastLiHeight - 23;
                    } else {
                        diff = diff + lastLiHeight + 5;
                    }
                    $j(this).attr('style', '--height:' + diff + 'px');
                    setTimeout(function () {
                        $j('ul.open:not(.orga)').children('li').children('.item')
                            .attr('style', '--width: 45px');
                    }, 700);
                });
            }, 1000);


        var count = 0;
        $j(orga).find('ul').each(function () {
            if ($j(this).hasClass('open')) {
                count++;
            }
        });

        if (count >= 3) {
            if ($j(ulOrga).hasClass('open')) {
                $j(orga).children('.item.active').addClass('closed');
                $j(orga).children('.item').not('.closed').hide();
                $j(orga).children('.open').addClass('removeMarginLeft');
                $j('.level-1-orga').not(orga).children('.item').hide();
                $j(ulOrga).removeClass('open');
            } else {
                var count2 = 0;

                $j(orga).find('ul').each(function () {
                    if ($j(this).hasClass('open')) {
                        $j(this).children('li').children('.item.active').addClass('closed');
                        $j(this).removeClass('open').addClass('closed');
                        if (count2 == 0) {
                            $j(this).children('li').children('.item').not('.closed').hide();
                            $j(this).children('li').children('.open').addClass(
                                'removeMarginLeft');
                            return false;
                        }
                    }
                });
            }
        }
            }

        setTimeout(function () {
            $j('html, body').stop().animate({
                'scrollTop': $j(self).offset().top - 300
            }, 100, 'swing');

        }, 20);


        });

        $j('.item').click(function () {

            if ($j(this).hasClass('closed')) {
                $j(this).find('.open-orga').trigger('click');
                $j(this).removeClass('closed');
                $j(this).parent().parent().find('ul').removeClass('closed').removeClass('removeMarginLeft');
                $j(this).parent().parent().find('.item').removeClass('closed').removeClass('active');
                return false;
            }

            var self = this;
            setTimeout(function () {
                $j('html, body').stop().animate({
                    'scrollTop': $j(self).offset().top - 300
                }, 100, 'swing');

            }, 100);
            var el = $j(this);
            $j('.item').removeClass('clicked');
            $j(el).addClass('clicked');
            // $j('header').hide();
            
            // Get HTML content in ajax
            
            var encodedContentId = encodeBase64Url($j(this).attr('data-ametys-content-id'));
            $j.ajax({
                url: AmetysOrganizationChart.contextPath + "/_content/" + encodedContentId + "/" + AmetysOrganizationChart.orgUnitViewName + ".html",
                dataType: "html",
                success: function(data) {
                    var document = new DOMParser().parseFromString(data, "text/html");
                    var content = $j(document).find("body").html();
                    $j("*[data-ametys-orgunit]").html(content).parent().show();
                },
                error: function(data) {
                    alert("{{i18n PLUGINS_USER_DIRECTORY_ORGANIZATION_CHART_ORGUNIT_ERROR}}");
                }
            });
            
            $j('.overlay').addClass('active');
            $j('.view-organizationChart').addClass('open');
        }).children('.open-orga').click(function (e) {
            return false;
        });
});

