/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.languages.LanguagesManager;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.collection.AmetysObjectCollection;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.UserExpression;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class UserDirectoryHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable,
Contextualizable {
    public static final String ROLE = UserDirectoryHelper.class.getName();
    public static final String USER_DIRECTORY_ROOT_NODE = "userdirectory";
    public static final String ORGUNITS_ATTRIBUTE = "orgunits";
    public static final String ORGUNIT_CONTENT_TYPE = "org.ametys.plugins.userdirectory.Content.udorgunit";
    public static final String ABSTRACT_USER_CONTENT_TYPE = "org.ametys.plugins.userdirectory.Content.user";
    protected AmetysObjectResolver _resolver;
    protected ContentTypeExtensionPoint _cTypeEP;
    protected AbstractCacheManager _cacheManager;
    protected LanguagesManager _languagesManager;
    protected Context _context;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._cTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._languagesManager = (LanguagesManager)manager.lookup(LanguagesManager.ROLE);
    }

    public void initialize() throws Exception {
        this._cacheManager.createMemoryCache(ROLE, new I18nizableText("plugin.user-directory", "PLUGINS_USER_DIRECTORY_USER_CACHE_LABEL"), new I18nizableText("plugin.user-directory", "PLUGINS_USER_DIRECTORY_USER_CACHE_DESCRIPTION"), true, null);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public AmetysObjectCollection getUserDirectoryRootContent() {
        return this.getUserDirectoryRootContent(false);
    }

    public AmetysObjectCollection getUserDirectoryRootContent(boolean create) {
        ModifiableTraversableAmetysObject userdirectoryNode;
        ModifiableTraversableAmetysObject pluginsNode = (ModifiableTraversableAmetysObject)this._resolver.resolveByPath("/ametys:plugins/");
        boolean needSave = false;
        if (!pluginsNode.hasChild(USER_DIRECTORY_ROOT_NODE)) {
            if (create) {
                pluginsNode.createChild(USER_DIRECTORY_ROOT_NODE, "ametys:unstructured");
                needSave = true;
            } else {
                throw new UnknownAmetysObjectException("Node '/ametys:plugins/userdirectory' is missing");
            }
        }
        if (!(userdirectoryNode = (ModifiableTraversableAmetysObject)pluginsNode.getChild(USER_DIRECTORY_ROOT_NODE)).hasChild("ametys:contents")) {
            if (create) {
                userdirectoryNode.createChild("ametys:contents", "ametys:collection");
                needSave = true;
            } else {
                throw new UnknownAmetysObjectException("Node '/ametys:plugins/userdirectory/ametys:contents' is missing");
            }
        }
        if (needSave) {
            pluginsNode.saveChanges();
        }
        return (AmetysObjectCollection)userdirectoryNode.getChild("ametys:contents");
    }

    public List<Content> getOrgUnits(Content user) {
        ContentValue[] contents = (ContentValue[])user.getValue(ORGUNITS_ATTRIBUTE);
        if (contents == null) {
            return List.of();
        }
        return Arrays.stream(contents).map(v -> v.getContentIfExists()).flatMap(Optional::stream).collect(Collectors.toList());
    }

    public List<Content> getUserContents(UserIdentity user) {
        return this.getUserContents(user, null);
    }

    public List<Content> getUserContents(UserIdentity user, String givenLanguage) {
        ArrayList<Content> userContents = new ArrayList<Content>();
        Iterator<String> languagesIterator = this._getLanguagesToTest(givenLanguage).iterator();
        while (languagesIterator.hasNext() && (userContents.isEmpty() || givenLanguage == null)) {
            String lang = languagesIterator.next();
            UserElementKey key = UserElementKey.of(lang, user);
            List contentIds = (List)this._getCache().get((Object)key, k -> this._requestUserContentIds(user, lang));
            userContents.addAll(contentIds.stream().map(id -> this._resolveContent((String)id, lang)).filter(Objects::nonNull).toList());
        }
        return userContents;
    }

    private Content _resolveContent(String contentId, String lang) {
        try {
            return contentId != null ? (Content)this._resolver.resolveById(contentId) : null;
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().warn("User content with id '{}' was not found in current workspace for language '{}'", (Object)contentId, (Object)lang);
            return null;
        }
    }

    public Content getUserContent(UserIdentity user, String givenLanguage) {
        List<Content> userContents = this.getUserContents(user, givenLanguage);
        return userContents.isEmpty() ? null : userContents.get(0);
    }

    private Set<String> _getLanguagesToTest(String givenLang) {
        LinkedHashSet<String> languages = new LinkedHashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)givenLang)) {
            languages.add(givenLang);
        }
        languages.add("en");
        languages.addAll(this._languagesManager.getAvailableLanguages().keySet());
        return languages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> _requestUserContentIds(UserIdentity user, String lang) {
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            ArrayList<String> cTypeIds = new ArrayList<String>();
            cTypeIds.add(ABSTRACT_USER_CONTENT_TYPE);
            cTypeIds.addAll(this._cTypeEP.getSubTypes(ABSTRACT_USER_CONTENT_TYPE));
            ContentTypeExpression cTyPeExpr = new ContentTypeExpression(Expression.Operator.EQ, cTypeIds.toArray(new String[cTypeIds.size()]));
            LanguageExpression langExpr = new LanguageExpression(Expression.Operator.EQ, lang);
            UserExpression userExpr = new UserExpression("user", Expression.Operator.EQ, user);
            AndExpression finalExpr = new AndExpression(new Expression[]{cTyPeExpr, langExpr, userExpr});
            String query = ContentQueryHelper.getContentXPathQuery((Expression)finalExpr);
            AmetysObjectIterable contents = this._resolver.query(query);
            List<String> list = contents.stream().map(AmetysObject::getId).toList();
            return list;
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }

    private Cache<UserElementKey, List<String>> _getCache() {
        return this._cacheManager.get(ROLE);
    }

    public void invalidateUserContentCache(String lang) {
        if (StringUtils.isNotBlank((CharSequence)lang)) {
            this._getCache().invalidate((Object)UserElementKey.of(lang));
        } else {
            this._getCache().invalidateAll();
        }
    }

    static class UserElementKey
    extends AbstractCacheKey {
        UserElementKey(String lang, UserIdentity userIdentity) {
            super(new Object[]{lang, userIdentity});
        }

        static UserElementKey of(String lang, UserIdentity userIdentity) {
            return new UserElementKey(lang, userIdentity);
        }

        static UserElementKey of(String lang) {
            return new UserElementKey(lang, null);
        }
    }
}

