/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.forms;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.forms.question.computing.AbstractStaticComputingType;
import org.ametys.plugins.forms.repository.FormEntry;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.userdirectory.forms.FormQuestionUDHelper;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.type.ModelItemType;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UDUserComputingQuestionType
extends AbstractStaticComputingType {
    private static final List<String> __ACCEPTED_TYPES = List.of("boolean", "date", "datetime", "double", "long", "string");
    protected CurrentUserProvider _currentUserProvider;
    protected FormQuestionUDHelper _formQuestionUDHelper;
    protected ContentTypeExtensionPoint _contentTypeEP;
    protected Map<String, ModelItem> _userComputingItems;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._formQuestionUDHelper = (FormQuestionUDHelper)manager.lookup(FormQuestionUDHelper.ROLE);
        this._contentTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
    }

    public Object getComputedValue(FormQuestion computedQuestion, FormEntry entry) {
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        return userIdentity != null ? this._formQuestionUDHelper.getUserContentAttributeValue(computedQuestion, userIdentity) : null;
    }

    public Map<String, ModelItem> getModelItems() {
        this._userComputingItems = this._formQuestionUDHelper.getUDModelItems(__ACCEPTED_TYPES);
        return this._userComputingItems;
    }

    public List<ViewItem> getViewElements() {
        LinkedList<ViewItem> viewElements = new LinkedList<ViewItem>();
        for (Map.Entry<String, ModelItem> modelItem : this._userComputingItems.entrySet()) {
            ViewElement userSelect = new ViewElement();
            userSelect.setDefinition((ElementDefinition)modelItem.getValue());
            viewElements.add((ViewItem)userSelect);
        }
        return viewElements;
    }

    public String getStorageType(FormQuestion question) {
        ModelItemType type = this._getAttributeType(question);
        return type.getId();
    }

    private ModelItemType _getAttributeType(FormQuestion question) {
        String contentTypeId = (String)question.getValue("user-content-type");
        ContentType contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
        String userAttribute = (String)question.getValue("ud-user-info-" + contentTypeId.replace(".", "-"));
        ModelItem modelItem = contentType.getModelItem(userAttribute);
        return modelItem.getType();
    }

    public List<String> getFieldToDisableIfFormPublished() {
        List fieldNames = super.getFieldToDisableIfFormPublished();
        for (String attributeId : this._userComputingItems.keySet()) {
            fieldNames.add(attributeId);
        }
        return fieldNames;
    }

    public boolean canEdit() {
        return false;
    }

    public void saxAdditionalValue(ContentHandler contentHandler, FormQuestion question, FormEntry entry) throws SAXException {
        ModelItemType type = this._getAttributeType(question);
        XMLUtils.createElement((ContentHandler)contentHandler, (String)"computing-attribut-type", (String)type.getId());
    }

    public Map<String, Object> getAnonymizedData(FormQuestion question) {
        return Map.of(question.getNameForForm(), "content://anonymized");
    }
}

