/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.observation;

import java.util.Map;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.VirtualFactoryExpression;
import org.ametys.plugins.userdirectory.page.OrgUnitPage;
import org.ametys.plugins.userdirectory.page.OrganisationChartPageResolver;
import org.ametys.plugins.userdirectory.page.UserDirectoryPageResolver;
import org.ametys.plugins.userdirectory.page.UserPage;
import org.ametys.plugins.userdirectory.page.VirtualOrganisationChartPageFactory;
import org.ametys.plugins.userdirectory.page.VirtualUserDirectoryPageFactory;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.cache.pageelement.PageElementCache;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageQueryHelper;
import org.ametys.web.repository.page.Zone;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Context;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractContentObserver
extends AbstractLogEnabled
implements Observer,
Serviceable,
Contextualizable {
    protected org.apache.avalon.framework.context.Context _context;
    protected Context _cocoonContext;
    protected AmetysObjectResolver _resolver;
    protected ContentTypesHelper _contentTypeHelper;
    protected PageElementCache _zoneItemCache;
    protected UserDirectoryPageResolver _userDirectoryPageResolver;
    protected OrganisationChartPageResolver _organisationChartPageResolver;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._contentTypeHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
        this._zoneItemCache = (PageElementCache)manager.lookup(PageElementCache.ROLE + "/zoneItem");
        this._userDirectoryPageResolver = (UserDirectoryPageResolver)((Object)manager.lookup(UserDirectoryPageResolver.ROLE));
        this._organisationChartPageResolver = (OrganisationChartPageResolver)((Object)manager.lookup(OrganisationChartPageResolver.ROLE));
    }

    public void observe(Event event, Map<String, Object> transientVars) {
        try {
            Content content = this._getTarget(event);
            if (this._isUserContent(content)) {
                AmetysObjectIterable<Page> rootPages = this._getUserRootPages();
                if (!rootPages.iterator().hasNext()) {
                    this.getLogger().debug("There's no user root page, nothing to invalidate");
                    return;
                }
                for (Page rootPage : rootPages) {
                    String cType = (String)rootPage.getValue("user-directory-root-contenttype");
                    if (!ArrayUtils.contains((Object[])content.getTypes(), (Object)cType)) continue;
                    this._internalObserve(event, rootPage, content);
                }
            } else if (this._isOrgUnitContent(content)) {
                AmetysObjectIterable<Page> rootPages = this._getOrgUnitRootPages();
                if (!rootPages.iterator().hasNext()) {
                    this.getLogger().debug("There's no orgUnit root page, nothing to invalidate");
                    return;
                }
                for (Page rootPage : rootPages) {
                    this._internalObserve(event, rootPage, content);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("Unable to observe event: " + String.valueOf(event), (Throwable)e);
        }
    }

    protected abstract void _internalObserve(Event var1, Page var2, Content var3);

    protected AmetysObjectIterable<Page> _getUserRootPages() {
        VirtualFactoryExpression expression = new VirtualFactoryExpression(VirtualUserDirectoryPageFactory.class.getName());
        String query = PageQueryHelper.getPageXPathQuery(null, null, null, (Expression)expression, null);
        return this._resolver.query(query);
    }

    protected AmetysObjectIterable<Page> _getOrgUnitRootPages() {
        VirtualFactoryExpression expression = new VirtualFactoryExpression(VirtualOrganisationChartPageFactory.class.getName());
        String query = PageQueryHelper.getPageXPathQuery(null, null, null, (Expression)expression, null);
        return this._resolver.query(query);
    }

    protected Content _getTarget(Event event) throws Exception {
        return (Content)event.getArguments().get("content");
    }

    protected boolean _isUserContent(Content content) {
        return content != null && this._contentTypeHelper.isInstanceOf(content, "org.ametys.plugins.userdirectory.Content.user");
    }

    protected boolean _isOrgUnitContent(Content content) {
        return content != null && this._contentTypeHelper.isInstanceOf(content, "org.ametys.plugins.userdirectory.Content.udorgunit");
    }

    protected void _removeZoneItemCache(Page rootPage, Content content, String workspace) {
        block6: {
            OrgUnitPage orgUnitPage;
            block5: {
                if (!this._isUserContent(content)) break block5;
                UserPage userPage = this._userDirectoryPageResolver.getUserPage(rootPage, content);
                if (userPage == null) break block6;
                AmetysObjectIterable zones = userPage.getZones();
                for (Zone zone : zones) {
                    for (ZoneItem zoneItem : zone.getZoneItems()) {
                        if (!zoneItem.getType().equals((Object)ZoneItem.ZoneType.CONTENT)) continue;
                        this._zoneItemCache.removeItem(workspace, rootPage.getSiteName(), "CONTENT", zoneItem.getId());
                    }
                }
                break block6;
            }
            if (this._isOrgUnitContent(content) && (orgUnitPage = this._organisationChartPageResolver.getOrgUnitPage(rootPage, content)) != null) {
                AmetysObjectIterable zones = orgUnitPage.getZones();
                for (Zone zone : zones) {
                    for (ZoneItem zoneItem : zone.getZoneItems()) {
                        if (!zoneItem.getType().equals((Object)ZoneItem.ZoneType.CONTENT)) continue;
                        this._zoneItemCache.removeItem(workspace, rootPage.getSiteName(), "CONTENT", zoneItem.getId());
                    }
                }
            }
        }
    }
}

