/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.observation;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.cache.CacheInvalidationPolicy;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class InvalidateCacheOnDisplayedContentValidationObserver
extends AbstractLogEnabled
implements Observer,
Serviceable {
    protected CacheInvalidationPolicy _cachePolicy;
    protected ContentTypesHelper _contentTypesHelper;
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._cachePolicy = (CacheInvalidationPolicy)manager.lookup(CacheInvalidationPolicy.ROLE);
        this._contentTypesHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public boolean supports(Event event) {
        Object object;
        String eventId = event.getId();
        if ((eventId.equals("content.validated") || eventId.equals("content.deleted")) && (object = event.getArguments().get("content")) != null && object instanceof Content) {
            Content content = (Content)object;
            return this._contentTypesHelper.isInstanceOf(content, "org.ametys.plugins.userdirectory.Content.user");
        }
        return false;
    }

    protected Set<Site> _getSitesWhereUserContentIsDisplayed(String contentId) {
        String xpathQuery = "//element(*, ametys:zoneItem)[@ametys-internal:service='org.ametys.plugins.userdirectory.service.InsertUser' and ametys:service_parameters/@ametys:contentId='" + contentId + "']";
        AmetysObjectIterable zoneItems = this._resolver.query(xpathQuery);
        return zoneItems.stream().filter(Objects::nonNull).map(zoneItem -> zoneItem.getZone().getSitemapElement()).filter(sitemapElem -> sitemapElem instanceof Page).map(page -> page.getSite()).collect(Collectors.toSet());
    }

    public int getPriority() {
        return 4000;
    }

    public void observe(Event event, Map<String, Object> transientVars) {
        block7: {
            String eventId;
            block6: {
                eventId = event.getId();
                if (!eventId.equals("content.validated")) break block6;
                Content content = (Content)event.getArguments().get("content");
                Set<Site> sites = this._getSitesWhereUserContentIsDisplayed(content.getId());
                for (Site site : sites) {
                    try {
                        this._cachePolicy.invalidateCacheOnContentModification(site, content);
                    }
                    catch (Exception e) {
                        this.getLogger().error("Unable to invalidate cache for displayed user content " + String.valueOf(content), (Throwable)e);
                    }
                }
                break block7;
            }
            if (!eventId.equals("content.deleted")) break block7;
            String contentId = (String)event.getArguments().get("content.id");
            Set<Site> sites = this._getSitesWhereUserContentIsDisplayed(contentId);
            for (Site site : sites) {
                try {
                    this._cachePolicy.invalidateCacheOnContentDeletion(site, contentId);
                }
                catch (Exception e) {
                    this.getLogger().error("Unable to invalidate cache for displayed user content " + contentId, (Throwable)e);
                }
            }
        }
    }
}

