/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.observation;

import java.util.Map;
import java.util.Set;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.userdirectory.UserDirectoryPageHandler;
import org.ametys.web.indexing.solr.SolrPageIndexer;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class UserContentCollectionSynchronizedObserver
implements Observer,
Serviceable {
    private UserDirectoryPageHandler _userPageHandler;
    private ContentTypesHelper _contentTypeHelper;
    private SolrPageIndexer _solrPageIndexer;

    public void service(ServiceManager manager) throws ServiceException {
        this._userPageHandler = (UserDirectoryPageHandler)((Object)manager.lookup(UserDirectoryPageHandler.ROLE));
        this._contentTypeHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
        this._solrPageIndexer = (SolrPageIndexer)manager.lookup(SolrPageIndexer.ROLE);
    }

    public boolean supports(Event event) {
        return event.getId().equals("contentio.collection.synchronized");
    }

    public int getPriority() {
        return 0;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        String cTypeId = (String)event.getArguments().get("collection.contentttype");
        if (this._contentTypeHelper.getAncestors(cTypeId).contains("org.ametys.plugins.userdirectory.Content.user")) {
            Set<Page> rootPages = this._userPageHandler.getUserDirectoryRootPages(cTypeId);
            for (Page rootPage : rootPages) {
                this._userPageHandler.clearCache(rootPage);
                this._solrPageIndexer.reindexPage(rootPage.getId(), true, false);
            }
        }
    }
}

