/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.observation;

import java.util.List;
import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.userdirectory.DeleteUserComponent;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class UserDeletedObserver
extends AbstractLogEnabled
implements AsyncObserver,
Serviceable {
    protected UserDirectoryHelper _userDirectoryHelper;
    protected DeleteUserComponent _deleteUserComponent;

    public void service(ServiceManager manager) throws ServiceException {
        this._deleteUserComponent = (DeleteUserComponent)manager.lookup(DeleteUserComponent.ROLE);
        this._userDirectoryHelper = (UserDirectoryHelper)((Object)manager.lookup(UserDirectoryHelper.ROLE));
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public boolean supports(Event event) {
        return "user.deleted".equals(event.getId());
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        UserIdentity identity = (UserIdentity)event.getArguments().get("user");
        List<Content> userContents = this._userDirectoryHelper.getUserContents(identity);
        int deletedContents = this._deleteUserComponent.deleteContentsWithLog(userContents, Map.of(), Map.of(), this.getLogger());
        if (userContents.size() != deletedContents) {
            this.getLogger().error("Something prevented the user content of a deleted user to be deleted");
        }
    }
}

