/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.synchronize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.directory.UserDirectoryFactory;
import org.ametys.core.user.directory.UserDirectoryModel;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.core.impl.user.directory.JdbcUserDirectory;
import org.ametys.plugins.core.impl.user.directory.LdapUserDirectory;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class UserPopulationSynchronizableContentsCollectionHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    private UserPopulationDAO _userPopulationDAO;
    private UserDirectoryFactory _userDirectoryFactory;

    public void service(ServiceManager manager) throws ServiceException {
        this._userPopulationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
        this._userDirectoryFactory = (UserDirectoryFactory)manager.lookup(UserDirectoryFactory.ROLE);
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public List<Map<String, Object>> getSupportedUserDirectories(String populationId) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(populationId);
        List userDirectories = userPopulation.getUserDirectories();
        for (String udId : this._getDatasourceBasedUserDirectories(userDirectories)) {
            UserDirectory userDirectory = userPopulation.getUserDirectory(udId);
            String udModelId = userDirectory.getUserDirectoryModelId();
            UserDirectoryModel udModel = this._userDirectoryFactory.getExtension(udModelId);
            HashMap<String, String> udMap = new HashMap<String, String>();
            udMap.put("id", udId);
            udMap.put("modelLabel", (String)udModel.getLabel());
            String label = userDirectory.getLabel();
            if (StringUtils.isNotBlank((CharSequence)label)) {
                udMap.put("label", label);
            }
            if (userDirectory instanceof JdbcUserDirectory) {
                udMap.put("type", "SQL");
            } else if (userDirectories instanceof LdapUserDirectory) {
                udMap.put("type", "LDAP");
            }
            result.add(udMap);
        }
        return result;
    }

    private List<String> _getDatasourceBasedUserDirectories(List<UserDirectory> userDirectories) {
        ArrayList<String> ids = new ArrayList<String>();
        for (UserDirectory userDirectory : userDirectories) {
            if (!(userDirectory instanceof JdbcUserDirectory) && !(userDirectory instanceof LdapUserDirectory)) continue;
            ids.add(userDirectory.getId());
        }
        return ids;
    }
}

