/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
const OLD_RETURNABLE = "org.ametys.plugins.userdirectory.service.search.UserReturnable";
const NEW_RETURNABLE = "org.ametys.plugins.userdirectory.service.search.UserPageReturnable";
const OLD_RETURNABLE_SUBTYPES = "ametys:UserSearchable-subContentTypes";
const NEW_RETURNABLE_SUBTYPES = "ametys:UserPageSearchable-subContentTypes";
const XPATH = "//element(*, ametys:zoneItem)[@ametys-internal:service = 'org.ametys.web.service.SearchService' and ametys:service_parameters/@ametys:returnables='" + OLD_RETURNABLE + "']";
 
function __updateReturnable(params)
{
    let hasChanges = false;
    
    // update returnable
    if (params.hasProperty("ametys:returnables"))
    {
        let values = params.getProperty("ametys:returnables").getValues();
        let newValues = [];
        
        for (var i=0; i < values.length; i++)  
        {  
            newValues.push(values[i].getString() == OLD_RETURNABLE ? NEW_RETURNABLE : values[i].getString());
        }
        
        Repository.helper.setProperty(params, "ametys:returnables", newValues);
        hasChanges = true;
    }
    
    // rename subttypes property
    if (params.hasProperty(OLD_RETURNABLE_SUBTYPES))
    {
        let oldTypeProp = params.getProperty(OLD_RETURNABLE_SUBTYPES);
        let typeVal = oldTypeProp.getValues();
        
        params.setProperty(NEW_RETURNABLE_SUBTYPES, typeVal)
        oldTypeProp.remove();
        
        hasChanges = true;
    }
    
    hasChanges = _updateOccurenceInSingleProperty(params, "ametys:criteria") || hasChanges;
    hasChanges = _updateOccurenceInMultipleProperty(params, "ametys:initialSorts") || hasChanges;
    hasChanges = _updateOccurenceInMultipleProperty(params, "ametys:facets") || hasChanges;
    hasChanges = _updateOccurenceInMultipleProperty(params, "ametys:proposedSorts") || hasChanges;
     
    return hasChanges;
}

function _updateOccurenceInSingleProperty(params, propName)
{
    if (params.hasProperty(propName))
    {
        let val = params.getProperty(propName).getString();
	    if (val.indexOf("UserSearchable") != -1)
	    {
	        val = val.replaceAll("UserSearchable", "UserPageSearchable");
	        params.setProperty(propName, val);
	        return true;
	    }        
    }
    return false;
}

function _updateOccurenceInMultipleProperty(params, propName)
{
    if (params.hasProperty(propName))
    {
        let needUpdate = false;
        let values = params.getProperty(propName).getValues();
        let newValues = [];
        for (var i=0; i < values.length; i++)  
        {  
            let val = values[i].getString();
            if (val.indexOf("UserSearchable") != -1)
	        {
	            val = val.replaceAll("UserSearchable", "UserPageSearchable");
                needUpdate = true;
	        }
            newValues.push(val);
        }
        
        if (needUpdate)
        {
            Repository.helper.setProperty(params, propName, newValues);
            return true;
        }        
    }
    return false;
}
        
function __migrateUserSearchServicesReturnable(session)
{
    let result = {
        count: 0
    };
    
    let nodes = Repository.query(XPATH, false, session);
    
    while (nodes.hasNext())
    {
        let node = nodes.next();
        let params = node.getNode("ametys:service_parameters");
        if (__updateReturnable(params)) { result.count++; };
    }
    
    session.save();
    logger.info(result.count + " user search services have been migrated in session " + session.getWorkspace().getName());
}

__migrateUserSearchServicesReturnable(Repository.session);
__migrateUserSearchServicesReturnable(Repository.liveSession);

