/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.observation;

import org.ametys.cms.ObservationConstants;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;

/**
 * Abstract {@link AsyncObserver} for synchronizing the Solr indexes.
 */
public abstract class AbstractSolrContentAsyncObserver extends AbstractSolrContentObserver implements AsyncObserver
{
    @Override
    protected Content _getTarget(Event event) throws Exception
    {
        String contentId = (String) event.getArguments().get(ObservationConstants.ARGS_CONTENT_ID);
        return _resolver.resolveById(contentId);
    }
}
