/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.observation;

import java.util.Map;
import java.util.Optional;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.userdirectory.page.UserDirectoryPageResolver;
import org.ametys.web.cache.AbstractCacheObserver;
import org.ametys.web.repository.page.Page;

/**
 * {@link Observer} when the user directory root is updated
 * Clear the cache for getting user page
 */
public class UserPageCacheObserver extends AbstractCacheObserver implements Serviceable
{
    /** The user directory page resolver */
    protected UserDirectoryPageResolver _userDirectoryPageResolver;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        _userDirectoryPageResolver = (UserDirectoryPageResolver) manager.lookup(UserDirectoryPageResolver.ROLE);
    }

    @Override
    public boolean supports(Event event)
    {
        return event.getId().equals(ObservationConstants.EVENT_USER_DIRECTORY_ROOT_CHANGED)  
                || event.getId().equals(ObservationConstants.EVENT_USER_DIRECTORY_ROOT_DELETED) 
                || event.getId().equals(ObservationConstants.EVENT_USER_DIRECTORY_ROOT_UPDATED); 
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        String lang = Optional.ofNullable(_getPage(event))
                .map(Page::getSitemapName)
                .orElse(null);
        
        _userDirectoryPageResolver.invalidateUserPageCache(lang);
    }
    
    private Page _getPage(Event event)
    {
        return (Page) event.getArguments().get(org.ametys.web.ObservationConstants.ARGS_PAGE);
    }
}
