/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.page;

import java.util.ArrayList;
import java.util.Map;
import java.util.SortedSet;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.virtual.VirtualAmetysObjectFactory;
import org.ametys.plugins.userdirectory.UserDirectoryPageHandler;
import org.ametys.plugins.userdirectory.page.AbstractUserDirectoryPageFactory;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPage;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class VirtualUserDirectoryPageFactory
extends AbstractUserDirectoryPageFactory
implements VirtualAmetysObjectFactory<Page> {
    @Override
    public void deferredService(ServiceManager manager) throws ServiceException {
        super.deferredService(manager);
        this._userDirectoryPageHandler = (UserDirectoryPageHandler)((Object)manager.lookup(UserDirectoryPageHandler.ROLE));
    }

    public Page getAmetysObjectById(String id) throws AmetysRepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean hasAmetysObjectForId(String id) throws AmetysRepositoryException {
        throw new UnsupportedOperationException();
    }

    public String getScheme() {
        return "udroot";
    }

    public AmetysObjectIterable<Page> getChildren(JCRAmetysObject parent) {
        if (!(parent instanceof Page)) {
            throw new IllegalArgumentException("The holder of the user directory virtual pages should be a page.");
        }
        ArrayList<AbstractConfigurableVirtualPage> children = new ArrayList<AbstractConfigurableVirtualPage>();
        Page rootPage = (Page)parent;
        int depth = this._userDirectoryPageHandler.getDepth(rootPage);
        if (depth > 0) {
            SortedSet<String> transitionalPagesName = this._userDirectoryPageHandler.getTransitionalPagesName(rootPage, "_root");
            for (String pageName : transitionalPagesName) {
                String pathName = this._userDirectoryPageHandler.getPathName(pageName);
                children.add(this.getTransitionalPageFactory().createTransitionalPage(rootPage, pageName, pathName));
            }
        } else {
            Map<String, String> userPagesContent = this._userDirectoryPageHandler.getUserPagesContent(rootPage, "_root");
            for (String contentId : userPagesContent.values()) {
                if (this._resolver.hasAmetysObjectForId(contentId)) {
                    Content content = (Content)this._resolver.resolveById(contentId);
                    children.add(this.getUserPageFactory().createUserPage(rootPage, content, "_root"));
                    continue;
                }
                this.getLogger().info("Content '{}' is stil referenced, but it does not exists anymore");
            }
        }
        return new CollectionIterable(children);
    }

    public Page getChild(JCRAmetysObject parent, String childName) {
        if (!(parent instanceof Page)) {
            throw new IllegalArgumentException("The holder of the user directory virtual pages should be a page.");
        }
        Page rootPage = (Page)parent;
        int intialDepth = this._userDirectoryPageHandler.getDepth(rootPage);
        if (intialDepth > 0) {
            String name;
            SortedSet<String> transitionalPagesName = this._userDirectoryPageHandler.getTransitionalPagesName(rootPage, "_root");
            if (transitionalPagesName.contains(name = this._userDirectoryPageHandler.getName(childName))) {
                return this.getTransitionalPageFactory().createTransitionalPage(rootPage, name, childName);
            }
            throw new UnknownAmetysObjectException("No transitional page named " + childName);
        }
        Map<String, String> userPagesContent = this._userDirectoryPageHandler.getUserPagesContent(rootPage, "_root");
        if (userPagesContent.containsKey(childName)) {
            Content content = (Content)this._resolver.resolveById(userPagesContent.get(childName));
            return this.getUserPageFactory().createUserPage(rootPage, content, "_root");
        }
        throw new UnknownAmetysObjectException("No user content named " + childName);
    }

    public boolean hasChild(JCRAmetysObject parent, String childName) {
        if (!(parent instanceof Page)) {
            throw new IllegalArgumentException("The holder of the user directory virtual pages should be a page.");
        }
        Page rootPage = (Page)parent;
        int intialDepth = this._userDirectoryPageHandler.getDepth(rootPage);
        if (intialDepth > 0) {
            SortedSet<String> transitionalPagesName = this._userDirectoryPageHandler.getTransitionalPagesName(rootPage, "_root");
            String name = this._userDirectoryPageHandler.getName(childName);
            return transitionalPagesName.contains(name);
        }
        Map<String, String> userPagesContent = this._userDirectoryPageHandler.getUserPagesContent(rootPage, childName);
        return userPagesContent.containsKey(childName);
    }
}

