/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.sitemap;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.userdirectory.page.VirtualUserDirectoryPageFactory;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.sitemap.AbstractStaticSitemapIndicator;

public class UserDirectoryRootSitemapIndicator
extends AbstractStaticSitemapIndicator {
    public boolean matches(SitemapElement sitemapElement) {
        JCRAmetysObject jcrPage;
        Page page;
        return sitemapElement instanceof Page && (page = (Page)sitemapElement) instanceof JCRAmetysObject && this._isUserDirectoryRootPage(jcrPage = (JCRAmetysObject)page);
    }

    private boolean _isUserDirectoryRootPage(JCRAmetysObject jcrPage) {
        try {
            Node node = jcrPage.getNode();
            if (node.hasProperty("ametys-internal:virtual")) {
                List<Value> values = Arrays.asList(node.getProperty("ametys-internal:virtual").getValues());
                return values.stream().map(LambdaUtils.wrap(Value::getString)).anyMatch(v -> VirtualUserDirectoryPageFactory.class.getName().equals(v));
            }
            return false;
        }
        catch (RepositoryException e) {
            return false;
        }
    }
}

