/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.userdataprovider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ametys.cms.data.File;
import org.ametys.core.user.User;
import org.ametys.core.user.UserImageAccessor;
import org.ametys.core.util.ImageHelper;
import org.ametys.plugins.core.ui.user.AbstractImageReader;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;

public class UserDirectoryImageAccessor
implements UserImageAccessor {
    public static final String USER_DIRECTORY_TYPE = "UserDirectoryUpload";
    private File _file;
    private Logger _logger;

    public UserDirectoryImageAccessor(File file, Logger logger) {
        this._file = file;
        this._logger = logger;
    }

    public User.UserImage getImage(int size, int maxSize) {
        try {
            InputStream is = this._getCroppedImageInputStream(size);
            return new User.UserImage(is, this._file.getName(), null, Long.valueOf(this._file.getLastModificationDate().toInstant().toEpochMilli()), USER_DIRECTORY_TYPE);
        }
        catch (IOException e) {
            this._logger.error(String.format("Unable to provide the uploaded cropped image for file '%s'.", this._file.getName()), (Throwable)e);
            return null;
        }
    }

    private InputStream _getCroppedImageInputStream(int size) throws IOException {
        try (InputStream is = this._file.getInputStream();){
            ByteArrayInputStream byteArrayInputStream;
            String filename = this._file.getName();
            String format = FilenameUtils.getExtension((String)filename);
            format = AbstractImageReader.ALLOWED_IMG_FORMATS.contains(format) ? format : "png";
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                ImageHelper.generateThumbnail((InputStream)is, (OutputStream)buffer, (String)format, (int)0, (int)0, (int)0, (int)0, (int)size, (int)size);
                byteArrayInputStream = new ByteArrayInputStream(buffer.toByteArray());
            }
            return byteArrayInputStream;
        }
    }
}

